package ProdDatabase;
/*
 * @author robinson
 */
import java.sql.*;
import java.io.*;
import java.util.*;

public class ModuleSCTDAQInfo implements SCTDBInfo {
   Statement           statement;
   ResultSet           resultSet;
   StringBuffer        sqlStat;
   SCTDBInterface      db;
   Map testNameMap;

   String moduleSerialNo;
   Vector Tests;

   java.text.DecimalFormat ivFormatter = new java.text.DecimalFormat("#.###");
   java.text.DecimalFormat temperatureFormatter = new java.text.DecimalFormat("#.#");

   boolean DEBUG=false;

//   java.util.regex.Pattern lotNoPattern = java.util.regex.Pattern.compile("(Z\\d+-W\\d+).*"); // miss out the non-LOT info, eg Z39993-W12 X1 Y2

   public ModuleSCTDAQInfo(String moduleSerialNo)  {
       this.moduleSerialNo=moduleSerialNo;
       Tests = new Vector();
       testNameMap = new HashMap();
       for(int i=0;i<sctdaqDBTestNames.length;i++) testNameMap.put(sctdaqDBTestNames[i],sctdaqNormalTestNames[i]);

       db = SCTDBInterface.getInstance();
       try { 
          getCharacterisationList();
          getDefects();
          getFailedTests();
       }catch(Exception e){System.err.println(e.toString());}
               
   }

  public int noTests() {
    return Tests.size();
    }
  public SCTDAQCharacterisation getCharacterisation(int index) {
    if(index>=Tests.size()) {
      System.out.println("Invalid sctdaq test index");
      return null;
      }
    return (SCTDAQCharacterisation) Tests.elementAt(index);
    }


//***************************************************************************************************
private void getCharacterisationList() throws Exception {

     if(!db.isConnected()) throw new Exception("No database connection");
     StringBuffer sqlStat = new StringBuffer("SELECT tests.ser_no,tests.locn_name,tests.test_date,sct_tstdcsinfo.T0,sct_tstdcsinfo.T1");
     sqlStat.append(" FROM tests,sct_tstdcsinfo");
     sqlStat.append(" WHERE tests.ser_no = "+moduleSerialNo);
     sqlStat.append(" AND tests.test_name = 'HybRC'");
     sqlStat.append(" AND sct_tstdcsinfo.test_no=tests.test_no");
     sqlStat.append(" ORDER BY tests.test_date,tests.test_no");

     statement = db.connection.createStatement();
     if(DEBUG) System.out.println(sqlStat.toString());
     resultSet = statement.executeQuery(sqlStat.toString());

     for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
          String sn = resultSet.getString(1);
          String locn = resultSet.getString(2);
          String date = guiUtilities.DaveUtils.extractDate(resultSet.getString(3));
          double T0 = Double.parseDouble(resultSet.getString(4));
          double T1 = Double.parseDouble(resultSet.getString(5));
          double Tdiff = (T1!=128.0) ? T0-T1 : 0.;
          SCTDAQCharacterisation sctdaq = new SCTDAQCharacterisation(locn,date,T0,Tdiff);
          Tests.addElement(sctdaq);
	  }
     statement.close();

     }

//***************************************************************************************************
private void getDefects() throws Exception {


   for(int i=0;i<Tests.size();i++) {
     SCTDAQCharacterisation sctdaq = (SCTDAQCharacterisation)Tests.elementAt(i);
     String locn = sctdaq.getLocation();
     String date = sctdaq.getDate();
     boolean isWarm = (sctdaq.getTemperature()>10.);
     if(!db.isConnected()) throw new Exception("No database connection");
     StringBuffer sqlStat = new StringBuffer("SELECT chan_1st,chan_last,defect_name");
     sqlStat.append(" FROM tests,defects,sct_tstdcsinfo");
     sqlStat.append(" WHERE tests.ser_no = "+moduleSerialNo+" AND tests.locn_name='"+locn+"'");
     sqlStat.append(" AND tests.test_name LIKE 'Hyb%'");
     sqlStat.append(" AND defects.test_no=tests.test_no AND sct_tstdcsinfo.test_no=tests.test_no");
     sqlStat.append(" AND tests.test_date='"+date+"'");
     if(isWarm) sqlStat.append(" AND sct_tstdcsinfo.T0>10");
     else  sqlStat.append(" AND sct_tstdcsinfo.T0<=10");
     sqlStat.append(" ORDER BY tests.test_date,tests.test_no");

     statement = db.connection.createStatement();
     if(DEBUG) System.out.println(sqlStat.toString());
     resultSet = statement.executeQuery(sqlStat.toString());

     int ntot=0;
     int ntot_consecutive=0;
     int ntot_ex=0;
     int ntot_consecutive_ex=0;
     Hashtable defectHash = new Hashtable();
     Hashtable noTrimDefectHash = new Hashtable();
     for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
          String chan1 = resultSet.getString(1);
          String chan2 = resultSet.getString(2);
          String testname = resultSet.getString(3);
          boolean isTrim = (testname.indexOf("TR_")!=-1);
          int c1 = Integer.parseInt(chan1);
          int c2 = Integer.parseInt(chan2);
          int ncon = c2-c1+1;
          if(ncon>ntot_consecutive) ntot_consecutive=ncon;
          if(!isTrim && ncon>ntot_consecutive_ex) ntot_consecutive_ex=ncon;
          for(int j=c1;j<=c2;j++) {
             Integer thisDefect = new Integer(j);
             if(!defectHash.containsKey(thisDefect)) {
                 defectHash.put(thisDefect,"1");
                 ntot++;
                 }
             if(!isTrim && !noTrimDefectHash.containsKey(thisDefect)) {
                 noTrimDefectHash.put(thisDefect,"1");
                 ntot_ex++;
                 }
             }
          }
      sctdaq.setDefects(0,ntot);
      sctdaq.setDefects(1,ntot_consecutive);
      sctdaq.setDefects(2,ntot_ex);
      sctdaq.setDefects(3,ntot_consecutive_ex);
      Tests.setElementAt(sctdaq,i);
      statement.close();
     }


     }

//***************************************************************************************************
private void getFailedTests() throws Exception {


   for(int i=0;i<Tests.size();i++) {
     SCTDAQCharacterisation sctdaq = (SCTDAQCharacterisation)Tests.elementAt(i);
     String locn = sctdaq.getLocation();
     String date = sctdaq.getDate();
     boolean isWarm = (sctdaq.getTemperature()>10.);
     if(!db.isConnected()) throw new Exception("No database connection");
     StringBuffer sqlStat = new StringBuffer("SELECT test_name FROM tests,sct_tstdcsinfo");
     sqlStat.append(" WHERE tests.ser_no = "+moduleSerialNo+" AND tests.locn_name='"+locn+"'");
     sqlStat.append(" AND tests.pass='NO'");
     sqlStat.append(" AND tests.test_name LIKE 'Hyb%'");
     sqlStat.append(" AND sct_tstdcsinfo.test_no=tests.test_no");
     sqlStat.append(" AND tests.test_date='"+date+"'");
     if(isWarm) sqlStat.append(" AND sct_tstdcsinfo.T0>10");
     else  sqlStat.append(" AND sct_tstdcsinfo.T0<=10");
     sqlStat.append(" ORDER BY tests.test_date,tests.test_no");

     statement = db.connection.createStatement();
     if(DEBUG) System.out.println(sqlStat.toString());
     resultSet = statement.executeQuery(sqlStat.toString());
     for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
        String name = (String)testNameMap.get(resultSet.getString(1));
        if(name!=null) sctdaq.addFailedTest(name);
        }
     statement.close();
     }
   }


}