/*
 * IVScanPlotter.java
 *
 * Created on 03 November 2003, 16:02
 */

package DisplayGUI.plotters;

import java.util.*;
import javax.swing.JPanel;
import java.awt.BorderLayout;
import hep.aida.*;
import hep.aida.ref.plotter.PlotterUtilities;

/**
 *
 * @author  robinson
 */
public class IVScanPlotter {
    private static IVScanPlotter instance = new IVScanPlotter();
    IAnalysisFactory af;
    ITree tree;
    IDataPointSetFactory dpsf=null;
    private JPanel panel;
    private IPlotter iplotter=null;
    
    private IVScanPlotter() {
        initialise();
        }    

    private void initialise() {
            af = IAnalysisFactory.create();
            tree = af.createTreeFactory().create();                    
    }    
    public static IVScanPlotter getInstance() {
        return instance;
    }
    
    public IDataPointSetFactory getDataPointSetFactory() {
       if(dpsf==null) dpsf=af.createDataPointSetFactory(tree);
       return dpsf;
      }
    public IPlotter getIPlotter() {
       if(iplotter==null) iplotter = af.createPlotterFactory().create();  
       return iplotter;
      }

    public JPanel getPlotPanel() {
        if (panel == null) {
            panel = new JPanel();

            // Now embed the plotter
            panel.add(PlotterUtilities.componentForPlotter(getIPlotter()), BorderLayout.CENTER);
        }
        
        return panel;
    }
    

    
}
