/*
 * JFrame.java
 *
 * Created on 26 March 2004, 12:10
 */

package DisplayGUI.plotters;
//import java.awt.*;
import java.awt.event.*;
import javax.swing.event.*;

/**
 *
 * @author  robinson
 */
public class IVPlotDisplay extends javax.swing.JFrame implements ListSelectionListener,DisplayGUI.displayParams {


    private javax.swing.JButton jButton1;
    private javax.swing.JLabel jLabel1;

    private javax.swing.JList snList;
    private String[] defaultString = {"No data"};

    private boolean selectionListenerIsActive=true;

    private IVScanPlotter ivPlotter;

    private IVScansData ivScansData;
    
    /** Creates new form JFrame */
    public IVPlotDisplay() {
        ivPlotter = IVScanPlotter.getInstance();
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel1 = new javax.swing.JLabel();
        jLabel1.setFont(displayBoldFont);
        jLabel1.setForeground(darkBlueColor);
        jLabel1.setBackground(backgroundColor);
        jButton1 = new javax.swing.JButton();

        snList = new javax.swing.JList(defaultString);
        snList.setFont(displayScaleFont);
        snList.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);

        snList.setSelectedIndex(0);
        snList.addListSelectionListener(this);

        javax.swing.JScrollPane viewScrollPane = new javax.swing.JScrollPane(snList);
        javax.swing.JLabel header2 = new javax.swing.JLabel("Plot Options");
        header2.setForeground(darkBlueColor);
        header2.setBackground(backgroundColor);
        header2.setFont(displayTextFont);
        viewScrollPane.setColumnHeaderView(header2);
        viewScrollPane.getColumnHeader().setBackground(backgroundColor);
        viewScrollPane.setBorder(new javax.swing.border.EmptyBorder(0,0,0,0));
        viewScrollPane.setHorizontalScrollBarPolicy(javax.swing.JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        viewScrollPane.getVerticalScrollBar().setBackground(backgroundColor);


        getContentPane().setLayout(new java.awt.GridBagLayout());

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
//        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
//        gridBagConstraints.anchor = java.awt.GridBagConstraints.CENTER;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.weighty = 0.1;
        getContentPane().add(jLabel1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        getContentPane().add(IVScanPlotter.getInstance().getPlotPanel(), gridBagConstraints);
        IVScanPlotter.getInstance().getPlotPanel().setBackground(backgroundColor);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.CENTER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.9;
        gridBagConstraints.gridheight = 2;
        getContentPane().add(viewScrollPane, gridBagConstraints);

        jButton1.setText("Close");
        jButton1.setFont(displayScaleFont);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.CENTER;
        jButton1.addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
                     exitForm(null);             
                     }
             });



        getContentPane().add(jButton1, gridBagConstraints);
        getContentPane().setBackground(backgroundColor);
        setBackground(backgroundColor);

    }
    
    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {
        setVisible(false);
    }

    public void showData(IVScansData ivScansData, String selectedModule) {
       this.ivScansData=ivScansData;

//       selectionListenerIsActive=false;
       snList.setListData(ivScansData.getModuleList().toArray());
       if(selectedModule!=null) snList.setSelectedValue(selectedModule,true);
       else snList.setSelectedIndex(0);
       plotData(snList.getSelectedIndex());
//       selectionListenerIsActive=true;
      
       }

    public void valueChanged(ListSelectionEvent e) {

        if (e.getValueIsAdjusting())
            return;

        javax.swing.JList theList = (javax.swing.JList)e.getSource();
        if (theList.isSelectionEmpty()) {
              // huh?
        } else {

        if(!selectionListenerIsActive) {
             return;
             }
        plotData(theList.getSelectedIndex());


        }
    }

   private void plotData(int index) {
       if(index<0) return;
       jLabel1.setText(ivScansData.getTitle()+" : "+(String)snList.getSelectedValue());
       hep.aida.IPlotter iPlotter = ivPlotter.getIPlotter();
       iPlotter.clearRegions();
       if(index==0) for(int i=0;i<ivScansData.size();i++) iPlotter.region(0).plot(ivScansData.getDataPointSet(i)); // index=0 all modules
       else iPlotter.region(0).plot(ivScansData.getDataPointSet(index-1));                                         // module index-1
// change default styles


       iPlotter.region(0).style().dataStyle().setParameter("showHistogramBars","false");
       iPlotter.region(0).style().dataStyle().setParameter("showErrorBars","false");
       iPlotter.region(0).style().dataStyle().setParameter("fillHistogramBars","false");
       iPlotter.region(0).style().dataStyle().setParameter("showDataPoints","true");
       iPlotter.region(0).style().dataStyle().setParameter("connectDataPoints","true");

       iPlotter.region(0).style().xAxisStyle().setLabel("Voltage (Volts)");
       iPlotter.region(0).style().yAxisStyle().setLabel("Current (microAmps)");


//       iPlotter.region(0).style().titleStyle().reset();

       iPlotter.region(0).style().setParameter("showStatisticsBox","false");
       iPlotter.region(0).style().setParameter("legendFont","Arial");


//       if(index==0) iPlotter.region(0).style().setParameter("showLegend","true");
//       else iPlotter.region(0).style().setParameter("showLegend","false");
//       iPlotter.region(0).style().setParameter("showTitle","false");


       pack();
       show();
       }
            
       


    
    

    
}
