package DisplayGUI;
import java.util.*;
import java.util.regex.*;
import java.io.*;
import ProdDatabase.*;
import Preferences.*;

public class UploadManager implements TestDataInfo, SCTDBInfo {
      gui guiControl;
      Map uploads, dcsMap, testMap, snMap;
      String testregex,user,username;
      Pattern runPattern = Pattern.compile("Run [Nn]umber\\s*:\\s*(.*)");
      Pattern serialNoPattern = Pattern.compile("SERIAL NUMBER\\s*:\\s*(\\d{14}|CRATE\\d{2}CHAN\\d{2}).*");
      Pattern snPattern = Pattern.compile("(\\d{14})");
      Pattern testDatePattern = Pattern.compile("TEST[_\\s]+DATE\\s*:\\s*(\\d+)/(\\d+)/(\\d+)");
      Pattern locationPattern = Pattern.compile("LOCATION\\s*(NAME|MADE)\\s*:.*");
      Pattern userPattern = Pattern.compile("TEST\\s*MADE\\s*BY.*");
      Pattern timeFlag = Pattern.compile("^#TIME$");
      Pattern versionFlag = Pattern.compile("^#VERSION\\s*$");
      Pattern testPattern;
      Pattern timePattern = Pattern.compile("\"\\d{2}:\\d{2}:\\d{2}\"");
      TestSelection testSelection;
      IVTestSelection ivTestSelection;
      PreferencesInterface prefs;
      boolean dcsWarning=false;
      boolean dcsIsMissing=false;

   
      public UploadManager(gui parent) {

        guiControl = parent;

        snMap = new HashMap();

        createSignatureMap();

        prefs = PreferencesInterface.getInstance();


        uploads = new HashMap();
        testSelection = guiControl.tablesDisplayPane.getTestSelection();
        ivTestSelection = guiControl.tablesDisplayPane.getIVTestSelection();

        if(checkVariables()) {
          getTestRegex();
          getSignatures();
          removePreviousUploads();
          if(uploads.size()>0 && dcsOK()) {
             createUploadFiles();
             String classpath = System.getProperty("guiclasspath", null);
             if(classpath!=null) {
                String cmd = "java -cp "+classpath+" UploadTestData "+prefs.getPreference(PreferencesInterface.UPLOAD_DIR)+"/*.upl "+username+" "+prefs.getPreference(PreferencesInterface.PASSWORD);
                guiControl.uploader.start(uploads.size(), cmd, false);
                }
            }
          }
        }

    boolean checkVariables() {
       if(testSelection!=null) {
         int testIndex = testSelection.getTestIndex();
         if(testIndex==-1) return false;
         if(!testIsSCTDAQ[testIndex]) {
            javax.swing.JOptionPane.showMessageDialog(null,"Uploads are not possible for "+testNames[testIndex]+" Tests.","SCT Database Upload",javax.swing.JOptionPane.INFORMATION_MESSAGE);
            return false;
            } 
         int status = testSelection.getTestStatus();
         if(status!=1) {
           javax.swing.JOptionPane.showMessageDialog(null,"Test is not finished. Please wait until completion before attempting to upload.","SCT Database Upload",javax.swing.JOptionPane.INFORMATION_MESSAGE);
           return false;
           } 
         }

        else if(ivTestSelection==null) return false;


        if(guiControl.uploader.isBusy()) {
          javax.swing.JOptionPane.showMessageDialog(null,"An upload is currently in progress... please wait until it is finished.","SCT Database Upload",javax.swing.JOptionPane.INFORMATION_MESSAGE);
          return false;
          }         
        if(prefs.getPreference(PreferencesInterface.INSTITUTE).equals(PreferencesInterface.unDefinedString)) {
          javax.swing.JOptionPane.showMessageDialog(null,"You must define your 'Upload Institute' before uploading anything... use the Preferences menu.","SCT Database Upload",javax.swing.JOptionPane.INFORMATION_MESSAGE);
          return false;
          }
        if(prefs.getPreference(PreferencesInterface.PASSWORD).equals(PreferencesInterface.unDefinedString)) {
          javax.swing.JOptionPane.showMessageDialog(null,"You must define your SCTDB password before uploading anything... use the Preferences menu.","SCT Database Upload",javax.swing.JOptionPane.INFORMATION_MESSAGE);
          return false;
          }
        try {
          Vector users = ProdDatabase.GeneralUtilities.getNameList(prefs.getPreference(PreferencesInterface.INSTITUTE));
          if(users.size()==0) return false;
          user = (String)users.firstElement();
          username = ProdDatabase.GeneralUtilities.getUserName(prefs.getPreference(PreferencesInterface.INSTITUTE));
          if(username==null) {
               System.err.println("SctGUI::UploadManager - No username found for your location");
               return false;
               }
        }catch(Exception db){System.err.println("SctGUI::UploadManager - failed to get username - "+db.toString()); return false;}

          return true;
        }


     private void removePreviousUploads() {

       int runno=-1,scanno=-1;

       if(testSelection!=null) {
          runno = testSelection.getRunNo();
          scanno = testSelection.getScanNo();
          }
       else if(ivTestSelection!=null) {
          runno = ivTestSelection.getRunNo();
          scanno = ivTestSelection.getScanNo();
          }

       if(runno==-1 || scanno==-1) {
           uploads=new HashMap();
           return;
           }
       String runNo = Integer.toString(runno)+"-"+Integer.toString(scanno);
       int testIndex = (testSelection!=null) ? testSelection.getTestIndex() : TEST_IV;
       try {
         ProdDatabase.GeneralUtilities.removePreviousUploads(sctdaqDBTestNames[testIndex], runNo,  prefs.getPreference(PreferencesInterface.INSTITUTE), uploads);
       }catch(Exception db){System.err.println("SctGUI::UploadManager - error checking previous uploads - "+db.toString()); uploads=new HashMap();}
       }

     private void getTestRegex() {
        StringBuffer regex=new StringBuffer();
        int count=0;
        for(int i=0;i<resultFileKeyNames.length;i++) {
           if(resultFileKeyNames[i].equals("")) continue;
           if(count!=0) regex.append("|");
           count++;
           regex.append("%"+resultFileKeyNames[i]);
           }
        testregex=regex.toString();
        testPattern = Pattern.compile("^"+testregex);
        }

      private void getSignatures() {

        String header=null;
        if(testSelection!=null) header = testSelection.getResultObjectHeader();
        if(header==null) header = ivTestSelection.getResultObjectHeader();
        if(header==null) return;

// enumerate through all modules

       for(Enumeration e = ConfigurationInterface.getInstance().getSerialNumberMap(guiControl.displayPane.getSCTView()).elements(); e.hasMoreElements();) {
           ModuleCell thisCell = (ModuleCell) e.nextElement();
           String sn = thisCell.getSerialNo();
           String objectName = header+sn;

           try {
               if(!Sct.IS.SctNames.getISRepository().contains(objectName)) continue;
               if(!ProdDatabase.GeneralUtilities.itemExists(sn)) {
                    System.out.println(sn+" does not exist in the database!");
                    continue;
                    }
               TestSummaryIS result = new TestSummaryIS(); 
               Sct.IS.SctNames.getISRepository().getValue(objectName, result); 
               String signature = getSignature(sn,result.dataString);
               if(signature!=null) uploads.put(signature,objectName);
           }catch(Exception e2){System.err.println("SctGUI::UploadManager - failed to retrieve signatures: "+e2.toString());}
        }

    }

    private String getSignature(String sn, String resultObject) {

      Matcher matcher;

      Hashtable thisHash = new Hashtable();

      boolean nextLineIsTime=false;
      boolean hasDCS=false;

      String[] lines = resultObject.split("\\n");      

      for(int i=0;i<lines.length;i++) {
          String line = lines[i];
          if(line.equals("")) continue; // shouldn't be necessary

          if(line.startsWith("%DCS_INFO")) hasDCS=true;

          matcher = testPattern.matcher(line);
          if(matcher.matches()) {
                        String theScanType = line.substring(matcher.start()+1,matcher.end());
                        thisHash.put("TEST",(String)testMap.get(theScanType));
                        break; // last line of interest in the file
                        }
          matcher = serialNoPattern.matcher(line);
          if(matcher.matches()) {
                      String thisSN = line.substring(matcher.start(1),matcher.end(1));
                      if(!thisSN.startsWith("CRATE") && !thisSN.equals(sn)) continue;
                      thisHash.put("SERIALNO",sn);
                      snMap.put(thisSN,sn);
                      continue;
                      }
          matcher = runPattern.matcher(line);
          if(matcher.matches()) {
                      thisHash.put("RUNNO",line.substring(matcher.start(1),matcher.end(1)));
                      continue;
                      }
          matcher = testDatePattern.matcher(line);
          if(matcher.matches()) {
                     thisHash.put("DATE",getDate(line));
                     continue;
                     }
          if(nextLineIsTime) {
             matcher=timePattern.matcher(line);
             if(matcher.matches()) {
                      thisHash.put("TIME",line.substring(matcher.start()+1,matcher.end()-1));
                      continue;
                      }  
             }

          nextLineIsTime = timeFlag.matcher(line).matches();
          } 
  
          if(thisHash.size()!=5) {
             System.err.println("SctGUI::UploadManager Missing info in signature");
             System.out.println(thisHash);
             return null;
             }

           StringBuffer thisSignature = new StringBuffer();
           if(thisHash.containsKey("SERIALNO")) thisSignature.append((String)thisHash.get("SERIALNO"));
           if(thisHash.containsKey("TEST")) thisSignature.append("_"+(String)thisHash.get("TEST"));
           if(thisHash.containsKey("RUNNO")) thisSignature.append("_"+(String)thisHash.get("RUNNO"));  
           if(thisHash.containsKey("DATE")) thisSignature.append("_"+(String)thisHash.get("DATE"));  
           if(thisHash.containsKey("TIME")) thisSignature.append("_"+(String)thisHash.get("TIME")); 

           if(!hasDCS) dcsIsMissing=true;

           return thisSignature.toString();
        } 


    public void createUploadFiles() {

         Calendar rightnow = Calendar.getInstance();
         long nowtime = rightnow.getTimeInMillis();
         File  uploadDir = new File(prefs.getPreference(PreferencesInterface.UPLOAD_DIR));
         File[] uploadFiles = uploadDir.listFiles(new UploadFileFilter());
         for(int i=0;i<uploadFiles.length;i++) {
            try {
              System.out.println("Deleting upload file "+uploadFiles[i].getAbsolutePath());
              uploadFiles[i].delete();
            }catch(Exception io1){System.err.println("SctGUI::UploadManager - failed to delete old upload files");}
         }

         int fileCount=0;

         try {
          for (Iterator i=uploads.entrySet().iterator(); i.hasNext(); ) {
            Map.Entry e = (Map.Entry) i.next();
            String objectName = (String) e.getValue();

            TestSummaryIS result = new TestSummaryIS(); 
            Sct.IS.SctNames.getISRepository().getValue(objectName, result); 
            String resultString = result.dataString;

            resultString = processUploadFile(resultString);


            Long tname = new Long(nowtime);
            String fname = "a"+tname.toString()+".upl";
            File tmpFile = new File(uploadDir,fname);
            if(tmpFile.exists()) {
                nowtime+=1000;
                tname = new Long(nowtime);
                fname = "a"+tname.toString()+".upl";
                }
            tmpFile = new File(uploadDir,fname);
            if(tmpFile.exists()) {
               System.out.println("ERROR: Upload file "+fname+" not created.");
               continue;
               }

            System.out.println("Creating "+tmpFile.getAbsolutePath());
            BufferedWriter out = new BufferedWriter(new FileWriter(tmpFile));
            out.write(resultString);
            out.close();
            nowtime++;
            fileCount++;
            }
          System.out.println("Created "+fileCount+" database upload files.");
         }catch(Exception e) {
            System.out.println("Error writing upload file(s) to "+uploadDir);
            }
         }

    private String processUploadFile(String resultString) {
        String[] lines = resultString.split("\\n");
        String sn=null;
        StringBuffer newString = new StringBuffer();
        int lineCount=0;
        boolean nextLineIsVersion=false;
        boolean dcsInfoIsPresent=false;
        for(int i=0;i<lines.length;i++) {
             String line = lines[i];
            if(line.equals("")) continue;
            if(lineCount>0) newString.append("\n");
            lineCount++;

            if(line.startsWith("%DCS_INFO")) dcsInfoIsPresent=true;

            Matcher matcher = serialNoPattern.matcher(line);
            if(matcher.matches()) {
                     sn = (String)snMap.get(line.substring(matcher.start(1),matcher.end(1))); // convert CRATEnnCHANnn to \\d{14} if necessary
                     line = "SERIAL NUMBER : "+sn;
                     newString.append(line);
                     continue;
                     }

            matcher = testDatePattern.matcher(line);
            if(matcher.matches()) {
                     line = "TEST DATE : "+getDate(line);
                     newString.append(line);
                     continue;
                     }
            matcher = locationPattern.matcher(line);
            if(matcher.matches()) {
                     line = "LOCATION NAME : "+prefs.getPreference(PreferencesInterface.INSTITUTE);
                     newString.append(line);
                     continue;
                     }
          matcher = runPattern.matcher(line);
          if(matcher.matches()) {
                      line = "Run number : "+line.substring(matcher.start(1),matcher.end(1));
                     newString.append(line);
                     continue;
                      }
            matcher = userPattern.matcher(line);
            if(matcher.matches()) {
                     line = "TEST MADE BY : "+user;
                     newString.append(line);
                     continue;
                     }
            matcher = testPattern.matcher(line);
            if(matcher.matches() && !dcsInfoIsPresent && dcsMap!=null && sn!=null) {
// add DCS info if possible
               SummaryReader.DCSInfo dcsInfo = (SummaryReader.DCSInfo)dcsMap.get(sn);
               if(dcsInfo!=null) appendDCSInfo(newString,dcsInfo);
               }

            if(nextLineIsVersion) {
               if(!line.startsWith("\"SctRodDaq")) {   // make sure DCS data has correct version string
                  line = "\"SctRodDaq_DCS_"+line.substring(1);
                  newString.append(line);
                  nextLineIsVersion=false;
                  continue;
                  }
               } 
            nextLineIsVersion = versionFlag.matcher(line).matches();

            newString.append(line);
            }
        return newString.toString();
        }

    private boolean dcsOK() {
          if(!dcsIsMissing) return true;
          Map dcsMap = guiControl.isInterface.getDCSMap(guiControl.tablesDisplayPane.getTestControlObjectName());
          if(dcsMap==null) {
            dcsWarning=true;
            int response = javax.swing.JOptionPane.showConfirmDialog(null,"There is no DCS information available for this test.\nUploading without DCS info is not recommended!\nDo you want to continue?","No DCS Info",javax.swing.JOptionPane.YES_NO_OPTION,javax.swing.JOptionPane.QUESTION_MESSAGE);
            if(response==javax.swing.JOptionPane.YES_OPTION) return true;
            else return false;
            }
          for (Iterator i=uploads.entrySet().iterator(); i.hasNext(); ) {
            Map.Entry e = (Map.Entry) i.next();
            String signature = (String) e.getKey();
            String sn = signature.substring(0,14);
            if(!dcsMap.containsKey(sn)) {
              int response = javax.swing.JOptionPane.showConfirmDialog(null,"There is no DCS information available for some or all of these tests.\nUploading without DCS info is not recommended!\nDo you want to continue?","No DCS Info",javax.swing.JOptionPane.YES_NO_OPTION,javax.swing.JOptionPane.QUESTION_MESSAGE);
              if(response!=javax.swing.JOptionPane.YES_OPTION) return false;
               }
          }
      return true;

    }

   private void appendDCSInfo(StringBuffer newString, SummaryReader.DCSInfo dcsInfo) {
       newString.append("%DCS_INFO");
       newString.append("\n#T0	T1");
       newString.append("\n"+dcsInfo.get(SummaryReader.DCSInfo.T0)+"  "+dcsInfo.get(SummaryReader.DCSInfo.T0));
       newString.append("\n#VDET	IDET");
       newString.append("\n"+dcsInfo.get(SummaryReader.DCSInfo.VDET)+"  "+dcsInfo.get(SummaryReader.DCSInfo.IDET));  
       newString.append("\n#VCC	ICC");
       newString.append("\n"+dcsInfo.get(SummaryReader.DCSInfo.VCC)+"  "+dcsInfo.get(SummaryReader.DCSInfo.ICC)); 
       newString.append("\n#VDD	IDD");
       newString.append("\n"+dcsInfo.get(SummaryReader.DCSInfo.VDD)+"  "+dcsInfo.get(SummaryReader.DCSInfo.IDD)); 
       newString.append("\n#TIME_POWERED\n.\n");
       }

  private void createSignatureMap() {
       testMap = new HashMap();
       for(int i=0;i<sctdaqDBTestNames.length;i++) {
          testMap.put(resultFileKeyNames[i],sctdaqDBTestNames[i]);
          }
        }
  private String getDate(String line) {
          Matcher matcher = testDatePattern.matcher(line);
          if(matcher.matches()) {
            String day = line.substring(matcher.start(1),matcher.end(1));
            String month = line.substring(matcher.start(2),matcher.end(2));
            String year = line.substring(matcher.start(3),matcher.end(3));
            if(month.length()==1) month="0"+month;
            if(day.length()==1) day="0"+day;
            return day+"/"+month+"/"+year;
            }
          return null;
          }
 

}
