/*
 * PlotOptionsFrame.java
 *
 * Created on 26 March 2004, 12:10
 */

package DisplayGUI;
import GuiComponents.Console.ExternalProcess;

/**
 *
 * @author  robinson
 */
public class PlotOptionsFrame extends javax.swing.JFrame implements displayParams {
   
    String objectName;
    java.util.regex.Pattern objectPattern = java.util.regex.Pattern.compile(".*::(\\w+)\\.(\\d+)\\.(\\d+)\\.(\\d{14})");
    
    /** Creates new form JFrame */
    public PlotOptionsFrame() {
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        getContentPane().setBackground(backgroundColor);

        jLabel1 = new javax.swing.JLabel();
        jTextField1 = new javax.swing.JTextField(14);
        jTextField2 = new javax.swing.JTextField(14);
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jCheckBox1 = new javax.swing.JCheckBox();
        jButton1 = new javax.swing.JButton();
        jButton2 = new javax.swing.JButton();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        jLabel1.setText("Plot data for module 20220330200001");
        jLabel1.setFont(displayTextFont);
        jLabel1.setForeground(darkBlueColor);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(jLabel1, gridBagConstraints);

        jTextField1.setFont(displayScaleFont);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        getContentPane().add(jTextField1, gridBagConstraints);

        jTextField2.setFont(displayScaleFont);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        getContentPane().add(jTextField2, gridBagConstraints);

        jLabel2.setText("Chip(s):");
        jLabel2.setFont(displayScaleFont);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        getContentPane().add(jLabel2, gridBagConstraints);

        jLabel3.setText("Channel(s):");
        jLabel3.setFont(displayScaleFont);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        getContentPane().add(jLabel3, gridBagConstraints);

        jCheckBox1.setText("Occupancy plot?");
        jCheckBox1.setFont(displayScaleFont);
        jCheckBox1.setBackground(backgroundColor);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        getContentPane().add(jCheckBox1, gridBagConstraints);

        jButton1.setText("Plot");
        jButton1.setFont(displayScaleFont);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHWEST;
        getContentPane().add(jButton1, gridBagConstraints);
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                showPlot();
            }
        });



        jButton2.setText("Close");
        jButton2.setFont(displayScaleFont);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHEAST;
        getContentPane().add(jButton2, gridBagConstraints);
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                exitForm(null);
            }
        });

        pack();
        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        java.awt.Dimension WSize = getSize();
        setLocation((screenSize.width-(int)WSize.getWidth())/2,(screenSize.height-(int)WSize.getHeight())/2);
    }
    
    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {
        setVisible(false);
    }
    

    public void showFrame(String objectName) {
       this.objectName=objectName;
       java.util.regex.Matcher matcher = objectPattern.matcher(objectName);
       if(matcher.matches()) {
         String dataType = objectName.substring(matcher.start(1),matcher.end(1));
         String run = objectName.substring(matcher.start(2),matcher.end(2));
         String scan = objectName.substring(matcher.start(3),matcher.end(3));
         String sn = objectName.substring(matcher.start(4),matcher.end(4));
         jLabel1.setText("Plot "+dataType+" for "+sn+" (Run/Scan "+run+"/"+scan+")");
         }
       else jLabel1.setText("Plot data from "+objectName);
       pack();
       setVisible(true);
       }


    private void showPlot() {
        java.util.regex.Pattern rangePattern = java.util.regex.Pattern.compile("(\\d+)-(\\d+)");
        java.util.regex.Pattern iPattern = java.util.regex.Pattern.compile("(\\d+)");
        java.util.regex.Matcher matcher,matcher2;
        StringBuffer options = new StringBuffer();
        boolean error=false;

        if(!jTextField1.getText().equals("")) {
          String[] chips = jTextField1.getText().split(",");
          for(int i=0;i<chips.length;i++) {
             matcher = rangePattern.matcher(chips[i]);
             matcher2 = iPattern.matcher(chips[i]);
             if(matcher.matches()) options.append(" -chip "+chips[i].substring(matcher.start(1),matcher.end(1))+" "+chips[i].substring(matcher.start(2),matcher.end(2)));
             else if(matcher2.matches()) options.append(" -chip "+chips[i].substring(matcher2.start(1),matcher2.end(1))+" "+chips[i].substring(matcher2.start(1),matcher2.end(1)));
             else error=true;
             } 
           }

        if(!jTextField2.getText().equals("")) {
          String[] chans = jTextField2.getText().split(",");
          for(int i=0;i<chans.length;i++) {
             matcher = rangePattern.matcher(chans[i]);
             matcher2 = iPattern.matcher(chans[i]);
             if(matcher.matches()) options.append(" -chan "+chans[i].substring(matcher.start(1),matcher.end(1))+" "+chans[i].substring(matcher.start(2),matcher.end(2)));
             else if(matcher2.matches()) options.append(" -chan "+chans[i].substring(matcher2.start(1),matcher2.end(1))+" "+chans[i].substring(matcher2.start(1),matcher2.end(1)));
             else error=true;
             }
           } 

      if(error) {
         javax.swing.JOptionPane.showMessageDialog(null,"Your channels or chips contained a syntax error.\nEnter numbers separated by commas, and/or ranges separated by dashes\neg '0-3,6,9'");
         return;
         }

      if(jCheckBox1.isSelected()) options.append(" -occ");



        try {
//              System.out.println("DataDisplayer " + options.toString()+" "+objectName);
            ExternalProcess p = new ExternalProcess("DataDisplayer " + options.toString()+" "+objectName);                                    
        } catch (Exception ioe) {
            System.out.println(ioe.getMessage());
            ioe.printStackTrace();
        }
   }
    
    
    // Variables declaration - do not modify
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JCheckBox jCheckBox1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JTextField jTextField1;
    private javax.swing.JTextField jTextField2;
    // End of variables declaration
    
}
