package DisplayGUI;

import java.io.*;
import java.util.*;
import javax.swing.*;
import javax.swing.text.*;
import java.util.regex.*;
import is.*;
import Sct.Serializable;
import Sct.IS.*;
import GuiComponents.Console.ExternalProcess;
import GuiComponents.Inspector.InspectorPanel;
import Sct_CalibrationController.TestData;
import GuiComponents.System.*;
import SummaryReader.*;

/*
 * ISInterface.java
 *
 */

/**
 *
 * @author  robinson
 */
public class ISInterface implements TestDataInfo,InfoListener {
    
    gui guiControl;
 
    ISRequestBuffer isRequestBuffer;
    ISCounter isCounter;

    Hashtable serverHash;  // hash to keep track of which servers we are subscribed to...
    String theObjectName;
//    String isFilterHeader;
//    String isFilterRunInfo;
    TestData testData;       // the currently selected test
    String serverName;       // the currently selected server name
    int noScans;             // the number of scans in the currently selected test

    int listFilterIndex;

    String eventServerRegex;      // regex for event server objects
    String fitServerRegex;        //regex for fit server objects
    String controlObjectRegex;          //regex for control data
    String rControlObjectRegex;
    String dbControlObjectRegex;   // regex for database control data
    String testServerRegex;          //regex for test server objects
    Pattern objectPattern, rObjectPattern;
    String resultObjectRegex;     // regex for test Summary objects
    String ivscanRegex;  // regex for ivscan objects
    String ivscanControlRegex;

    String eventServer;
    String fitServer;
    String testServer;
    String controlServer;
    String SCTDBServer;
    String retrievedArchiveServer;

    String testLocation;     // the test location for SCTDB downloads

    int serverIndex=0;        // the currently selected server

    boolean infoListenersAreActive=true;

//    Vector infoListenerQueue = new Vector();

    java.util.Map moduleCount = new HashMap();

    Pattern defectPattern = Pattern.compile("(\\d+)-(\\d+)\\s*:\\s*(\\w+)");
    guiUtilities.Cache cache=null;
    Map dcsMap = new HashMap();
    
    java.text.DecimalFormat nf = new java.text.DecimalFormat("#.###");

    Preferences.PreferencesInterface prefs;

    PlotOptionsFrame plotOptionsFrame=null;

    public ISInterface(gui parent) {
        guiControl=parent;

        prefs = Preferences.PreferencesInterface.getInstance();

        isRequestBuffer = new ISRequestBuffer(guiControl);

        is = GuiComponents.System.ISInterface.getInstance();
        isCounter = new ISCounter();
        serverHash = new Hashtable();
        noScans=0;
        listFilterIndex=-1;

        eventServerRegex = ".*RawScanResult.*[0-9]+\\.[0-9]+(\\.[0-9]{14})?";
        fitServerRegex = ".*FitScanResult.*[0-9]+\\.[0-9]+(\\.[0-9]{14})?";
        testServerRegex = ".*Result.*[0-9]+\\.[0-9]+(\\.[0-9]{14})?";
        controlObjectRegex = "TestData\\.[0-9]+\\.[0-9]+";
        rControlObjectRegex = "TestData\\.[0-9]+\\.[0-9]+.*Test";
        dbControlObjectRegex = "ControlData.TestData\\.[0-9]+\\.[0-9]+";
        resultObjectRegex = ".*(Summary).*";
        ivscanRegex = ".*IVScanData.*";
        ivscanControlRegex = ".*ControlIVScanData.*";

        objectPattern = Pattern.compile(".*TestData\\.[0-9]+\\.[0-9]+");
        rObjectPattern = Pattern.compile(".*\\.[0-9]+\\.[0-9]+.*Test");

        eventServer = SctNames.getEventISServer();
        fitServer = SctNames.getFitISServer();
        testServer = SctNames.getTestISServer();
        controlServer = SctNames.getControlISServer();
        SCTDBServer = "SCTDBData";
        retrievedArchiveServer = "RetrievedData";

        testLocation="Any";

        if(cache==null) setCacheSize(200);


    }
    protected void subscribe() {
        subscribe(-1);
        }

    public void setISCounter(String regex) {
        isCounter.refresh(regex);
        }
        
    protected void subscribe(int testType) {
        listFilterIndex=testType;
        String[] objects;
        Vector ISTests = new Vector();
 
        try {

        switch(guiControl.displayStatus.getStatus()) {
           case DisplayStatus.SCTDB_RODDAQ_DATA:
              objects = is.getISObjects(SCTDBServer,dbControlObjectRegex);
              for(int i=0;i<objects.length;i++) ISTests.addElement(objects[i]);
              break;
           case DisplayStatus.IV_DATA:
              objects = is.getISObjects(retrievedArchiveServer,ivscanControlRegex);
              for(int i=0;i<objects.length;i++) ISTests.addElement(objects[i]);
              break;
            default:
              objects = is.getISObjects(retrievedArchiveServer,rControlObjectRegex);
              for(int i=0;i<objects.length;i++) ISTests.addElement(objects[i]);
              objects = is.getISObjects(controlServer,controlObjectRegex);
              for(int i=0;i<objects.length;i++) ISTests.addElement(objects[i]);
              }

         if(guiControl.displayStatus.getStatus()!=DisplayStatus.IV_DATA) {
           for(int j=ISTests.size()-1;j>=0;j--) {
              String controlObject = (String)ISTests.elementAt(j);
              Matcher matcher = objectPattern.matcher(controlObject);
              Matcher matcher2 = rObjectPattern.matcher(controlObject);
              if(!matcher.matches() && !matcher2.matches()) {
                 ISTests.removeElementAt(j);
                 continue;
                 }
              if(listFilterIndex==-1) continue;
              else {
                 TestData testData = new TestData(); 
                 is.getRepository().getValue(controlObject, testData); 
                 String thisTestName = (listFilterIndex==TEST_3PTGAIN) ? testNames[TEST_NPTGAIN] : testNames[listFilterIndex];
                 if(testData.testName.indexOf(thisTestName)==-1) ISTests.removeElementAt(j);
                 }
              }  
             }
        guiControl.tablesDisplayPane.setTestTable(ISTests);

         switch(guiControl.displayStatus.getStatus()) {
          case DisplayStatus.IS_MONITOR:


            if(!serverHash.containsKey(eventServer)) {
              is.subscribe(eventServer, eventServerRegex, true, this);
              serverHash.put(eventServer, eventServerRegex);
              }
            if(!serverHash.containsKey(fitServer)) {
              is.subscribe(fitServer, fitServerRegex, true, this);
              serverHash.put(fitServer, fitServerRegex);
              }
            if(!serverHash.containsKey(testServer)) {
              is.subscribe(testServer, testServerRegex, true, this);
              serverHash.put(testServer, testServerRegex);
              }
            if(!serverHash.containsKey(controlServer)) {
             is.subscribe(controlServer, controlObjectRegex, true, this);
             serverHash.put(controlServer, controlObjectRegex);
             }
            if(!serverHash.containsKey(retrievedArchiveServer)) {
             List subscriptions = new ArrayList();
             subscriptions.add(rControlObjectRegex);
             subscriptions.add(fitServerRegex);
             subscriptions.add(eventServerRegex);
             subscriptions.add(testServerRegex);  
             for (ListIterator i = subscriptions.listIterator(); i.hasNext(); ) {
                is.subscribe(retrievedArchiveServer, (String)i.next(), true, this);
                }           
             serverHash.put(retrievedArchiveServer, subscriptions);
             }

            break;

          case DisplayStatus.TEST_DATA:
             if(!serverHash.containsKey(testServer)) {
               is.subscribe(testServer, resultObjectRegex, true, this);
               serverHash.put(testServer, resultObjectRegex);
             }
             if(!serverHash.containsKey(controlServer)) {
               is.subscribe(controlServer, controlObjectRegex, true, this);
               serverHash.put(controlServer, controlObjectRegex);
               }
            if(!serverHash.containsKey(retrievedArchiveServer)) {
             List subscriptions = new ArrayList();
             subscriptions.add(resultObjectRegex);
             subscriptions.add(rControlObjectRegex);
             for (ListIterator i = subscriptions.listIterator(); i.hasNext(); ) {
                is.subscribe(retrievedArchiveServer, (String)i.next(), true, this);
                }           
             serverHash.put(retrievedArchiveServer, subscriptions);
             }



             break;
          case DisplayStatus.SCTDB_DATA:
             if(!serverHash.containsKey(controlServer)) {
               is.subscribe(controlServer, controlObjectRegex, true, this);
               serverHash.put(controlServer, controlObjectRegex);
               }
             if(!serverHash.containsKey(SCTDBServer)) {
               is.subscribe(SCTDBServer, ".*", true, this);
               serverHash.put(SCTDBServer, ".*");
               }
              break;
          case DisplayStatus.SCTDB_RODDAQ_DATA:
             if(!serverHash.containsKey(SCTDBServer)) {
               is.subscribe(SCTDBServer, ".*", true, this);
               serverHash.put(SCTDBServer, ".*");
               }
              break;
          case DisplayStatus.IV_DATA:
             if(!serverHash.containsKey(retrievedArchiveServer)) {
               List subscriptions = new ArrayList();
               subscriptions.add(ivscanRegex);
               is.subscribe(retrievedArchiveServer, ivscanRegex, true, this);
               serverHash.put(retrievedArchiveServer, subscriptions);
               }
              break;
          case DisplayStatus.DCS_DATA:

	        Preferences.PreferencesInterface prefs = Preferences.PreferencesInterface.getInstance();
                if(!serverHash.containsKey(prefs.getPreference(prefs.DCS_SERVER_NAME))) {
			is.subscribe(prefs.getPreference(prefs.DCS_SERVER_NAME),".*",true,this);
			serverHash.put(prefs.getPreference(prefs.DCS_SERVER_NAME),".*");
			}
		break;
           default:
           }



        } catch (RuntimeException e) {
            System.err.println("SctGUI::ISInterface: Exception in IS subscription: " + e.toString());
        }
//        guiControl.displayPane.setDisplayColors();
//        guiControl.displayPane.refreshDisplay();   
    }

    protected void unsubscribe() {
            if(serverHash.containsKey(retrievedArchiveServer)) {
                List subscriptions = (List)serverHash.get(retrievedArchiveServer);
                for (ListIterator i = subscriptions.listIterator(); i.hasNext(); ) {
                  is.unsubscribe(retrievedArchiveServer, (String)i.next());
//                 System.out.println(is.unsubscribe(retrievedArchiveServer, (String)i.next()));
                  }  
                serverHash.remove(retrievedArchiveServer);
                }

            for(Enumeration e = serverHash.keys(); e.hasMoreElements();) {
               String server = (String)e.nextElement();
               String pattern = (String)serverHash.get(server);
               is.unsubscribe(server, pattern);
//               System.out.println(is.unsubscribe(server, pattern));
               }
            serverHash = new Hashtable();
    }

    public javax.swing.tree.DefaultMutableTreeNode getISTree() {

        String[] servers = is.getISServers();        
        
        //Setup tree
        
        javax.swing.tree.DefaultMutableTreeNode top = new javax.swing.tree.DefaultMutableTreeNode("IS Servers");
        javax.swing.tree.DefaultMutableTreeNode server;
        javax.swing.tree.DefaultMutableTreeNode object;
        for (int i=0; i<servers.length; i++) {
            server = new javax.swing.tree.DefaultMutableTreeNode(servers[i]);
            String[] objects = is.getISObjects(servers[i],".*");
            for (int j=0; j<objects.length; j++) {
                object = new javax.swing.tree.DefaultMutableTreeNode(objects[j]);
                server.add(object);
            }
            top.add(server);
        }
        return top;
//        trISServers.setModel(new DefaultTreeModel(top));
    }
    
    /** InfoListener interfaces
     */ 
    
    abstract class StringRunnable implements Runnable {
	protected String name;
	StringRunnable(String name) {
	    this.name = name;
	}	
    }
    
    public void infoCreated(InfoEvent e) {
       isCounter.addObject(e.getName());
       javax.swing.SwingUtilities.invokeLater(new StringRunnable(e.getName()) {
          public void run() {
                   isRequestBuffer.queueObject(name,true);
             }
        });
    }   
    
    
    public void infoDeleted(InfoEvent e) {
       javax.swing.SwingUtilities.invokeLater(new StringRunnable(e.getName()) {
          public void run() {   
             if(!infoListenersAreActive) return;
             if(name.startsWith("ControlData")) guiControl.tablesDisplayPane.removeTest(name);
             guiControl.displayPane.setDisplayColors();
             guiControl.displayPane.refreshDisplay();  // just refresh the display
          }
        });
    }
    
    public void infoUpdated(InfoEvent e) {
        javax.swing.SwingUtilities.invokeLater(new StringRunnable(e.getName()) {
          public void run() {  
            isRequestBuffer.queueObject(name,false);
            }
        });
    }

//***************************************************************************
   public void removeTests(Vector testObjectNames, int minRow, int maxRow) {
// remove tests from IS
// firstRowNo is the first row number in the test JTable
// lastTestNo is the last

      infoListenersAreActive=false;

      for(int i=maxRow;i>=minRow;i--) {
         String testObjectName = (String)testObjectNames.elementAt(i);
         TestData thisTestData = new TestData(); 
         is.getRepository().getValue(testObjectName, thisTestData); 
// first extract the run number, and scan numbers
         int runNo = thisTestData.runNumber;
         int startScanNumber = thisTestData.startScanNumber;
// form a regular espression
         StringBuffer regex = new StringBuffer(".*(");
         for(int k=thisTestData.startScanNumber;k<thisTestData.startScanNumber+thisTestData.nScans;k++) {
           if(k>thisTestData.startScanNumber) regex.append("|");
           regex.append("\\.");
           regex.append(Integer.toString(runNo));
           regex.append("\\.");
           regex.append(Integer.toString(k));
           regex.append("\\.");
         }
         regex.append(").*");
      
         String[] deletionObjects;
// check if all data objects are in RetrievedData server or not...
         if(!testObjectName.matches("RetrievedData.*")) {
           deletionObjects = is.getISObjects(SctNames.getEventISServer(),regex.toString());
           for(int j=0;j<deletionObjects.length;j++) System.out.println(is.remove(deletionObjects[j]));
           deletionObjects = is.getISObjects(SctNames.getFitISServer(),regex.toString());
           for(int j=0;j<deletionObjects.length;j++) System.out.println(is.remove(deletionObjects[j])); 
           deletionObjects = is.getISObjects(SctNames.getTestISServer(),regex.toString());
           for(int j=0;j<deletionObjects.length;j++) System.out.println(is.remove(deletionObjects[j]));  
           }
         else {
           deletionObjects = is.getISObjects("RetrievedData",regex.toString());
           for(int j=0;j<deletionObjects.length;j++) System.out.println(is.remove(deletionObjects[j]));  
           }
    
// finally, the control object itself
// the object names in the control server do not have a final '.' after the first scan no 
         System.out.println(is.remove(testObjectName)); 
         guiControl.tablesDisplayPane.removeTest(testObjectName);
        }

       infoListenersAreActive=true;
        
     }
//***************************************************8
        public void removeObjects(Vector objectNames) {
           for(int i=0;i<objectNames.size();i++) System.out.println(is.remove((String)objectNames.elementAt(i)));
           }
//***************************************************8
     public int getListFilterIndex() {
           return listFilterIndex;
           }
        
//****************************************************************************
//     public void setTestFilter(String testObjectName) {
//          if(testObjectName==null) testSelection=null;
//          else testSelection = new TestSelection(testObjectName,testLocation);
//          setIsFilterHeader();
//          setIsFilterRunInfo();
//          if(guiControl.displayStatus.getStatus()==DisplayStatus.IS_MONITOR) resetModuleCount();
//          } 
//*******************************************************
    private String getIsFilterHeader() {
         String isFilterHeader = "SctData::Result";
         int serverIndex = guiControl.selectorPane.getDisplayParameterIndex();
         switch(serverIndex) {
            case 0:
                isFilterHeader = "SctData::RawScanResult";
               break;
            case 1:
                isFilterHeader = "SctData::FitScanResult";
               break;
            case 2:
            default:
               TestSelection testSelection = guiControl.tablesDisplayPane.getTestSelection();
               if(testSelection!=null) {
                  String testName;
                  if((testName=testSelection.getTestName())!=null) isFilterHeader="SctData::"+testName+"Result";
                  }
               break;
            } 
         return isFilterHeader;
     }
    private String getIsFilterRunInfo() {
         String isFilterRunInfo="none";
         TestSelection testSelection = guiControl.tablesDisplayPane.getTestSelection();
         if(testSelection==null || testSelection.getTestData()==null) return isFilterRunInfo;
         StringBuffer regex = new StringBuffer("\\."+Integer.toString(testSelection.getRunNo())+"\\.(");
         int startScanNo = testSelection.getStartScanNumber();
         for(int k=startScanNo;k<startScanNo+testSelection.getNoScans();k++) {
           if(k>startScanNo) regex.append("|");
           regex.append(Integer.toString(k));
           regex.append("\\.");
         }
         regex.append(").*"); 
         return regex.toString();
         }
    private String getServerName() {
         int serverIndex = guiControl.selectorPane.getDisplayParameterIndex();
         String serverName=SctNames.getEventISServer();
         switch(serverIndex) {
            case 0:
               serverName=SctNames.getEventISServer();
               break;
            case 1:
               serverName=SctNames.getFitISServer();
               break;
            case 2:
            default:
               serverName=SctNames.getTestISServer();
               break;
            }
          return serverName;
          }

//**************************************************************************
      public String[] getISObjects(String serialNo) {
         return is.getISObjects(getServerName(),getIsFilterHeader()+getIsFilterRunInfo()+serialNo);
         }
//**********************************************************************
    public Hashtable getModuleISCounts() {
       String serverName = getServerName();
       Pattern snPattern = Pattern.compile(serverName+"\\."+getIsFilterHeader()+getIsFilterRunInfo()+"(\\d{14}).*");
       Hashtable thisHash = new Hashtable();
       String[] objects = is.getISObjects(serverName,getIsFilterHeader()+getIsFilterRunInfo()+".*");
       for(int i=0;i<objects.length;i++) {
           Matcher matcher = snPattern.matcher(objects[i]);
           if(matcher.matches()) {
               String sn = objects[i].substring(matcher.start(2),matcher.end(2));
               if(thisHash.containsKey(sn)) {
                   int count = ((Integer)thisHash.get(sn)).intValue();
                   count++;
                   thisHash.put(sn,new Integer(count));
                   }
               else thisHash.put(sn,new Integer(1));
               }
            }
        return thisHash;
        }



//*********************************************************************

   public void launchExternalViewer(String name) {
        try {
            ExternalProcess p = new ExternalProcess("DataDisplayer " + name);                                    
        } catch (Exception ioe) {
            System.out.println(ioe.getMessage());
            ioe.printStackTrace();
        }

    }

   public void launchExternalViewerWithOptions(String name) {
            if(plotOptionsFrame==null) plotOptionsFrame = new PlotOptionsFrame();
            plotOptionsFrame.showFrame(name);
    }
    

    public void viewISData(String name) {
        try {
            Serializable ob = ObjectManagerIS.getInstance().readObject(name);
            InspectorPanel p = new InspectorPanel(name, ob);
            //JFrame frame = new JFrame("InspectorPanel");
            //frame.getContentPane().add(p, java.awt.BorderLayout.CENTER);
            //frame.pack();
            //frame.show();

            JFrame frame2 = new JFrame("TreeTable");                    
            frame2.getContentPane().add(new JScrollPane(p.treeTable));
            frame2.pack();
            frame2.show();

        } catch (java.io.IOException ioe) {
            System.err.println("Error reading object from IS: " + ioe + "  " +ioe.getMessage() +"\n");
        }
    }

   public void downloadTests(int index) {
         TestSelection testSelection = guiControl.tablesDisplayPane.getTestSelection();
         if(testSelection==null || testSelection.getTestIndex()==-1) {
              javax.swing.JOptionPane.showMessageDialog(null,"You must select a test in ordre to download sctdaq reference data.");
              return;
              }
         boolean refresh=false;
         if(index==-1) {
           index=testSelection.getTestIndex();
           refresh=true;
           }
         if(index==-1) return;
         if(!testIsSCTDAQ[index]) {
            javax.swing.JOptionPane.showMessageDialog(null,"The selected test is not SCTDAQ compatible, so reference data cannot be downloaded.");
            return;
            }
         SCTDBTestDownloader d = new SCTDBTestDownloader(new Vector(guiControl.config.getSortedVector(guiControl.displayPane.getSCTView())),index,testLocation,true,refresh);
         if(d.downloadsRequired() && d.isOkToStart()) d.start();
         }
   public void setLocation(String location) {
        testLocation=location;
        TestSelection testSelection = guiControl.tablesDisplayPane.getTestSelection();
        if(testSelection!=null) testSelection.setSCTDBLocation(testLocation);
        }
   public String getLocation() {
        return testLocation;
        }

   public Double getSCTDBData(String resultObject, int testIndex) {
             if(testIndex==-1) return null;
             int parameterIndex = guiControl.selectorPane.getDisplayParameterIndex();
             int option = guiControl.selectorPane.getMouseClickIndex();
             if(parameterIndex<0) return null;
             SummaryReader.Test testResult = getSCTDBTest(resultObject);
             if(testResult==null) return null;
             Double theData=null;
                  switch(parameterIndex) {
                    case 0: // test status
                      theData = testResult.getTestInfo().getTestStatusData();
                      break;
                    case 1: // defect count
                      theData = testResult.noDefects();  
                      break;
                    case 2: // DCS conditions
                      SummaryReader.DCSInfo dcsInfo = testResult.getDCSInfo();
                      if(dcsInfo!=null) theData = dcsInfo.get(option);
                      break;
                    default:
                      theData = testResult.getLastDataBlock().get(option,parameterIndex-3);
                    }
              return theData;
              }

   public Test getSCTDBTest(String resultObject) {

        SummaryReader.Test testObject;

        testObject = (SummaryReader.Test)cache.get(resultObject);
        if(testObject!=null) return testObject;

        try {
        if(!Sct.IS.SctNames.getISRepository().contains(resultObject)) return null;
        SCTDB_Data result = new SCTDB_Data(); 
        Sct.IS.SctNames.getISRepository().getValue(resultObject, result); 

        testObject = new Test();

        int blockSize = result.data_m0.length;
        DataBlock dataBlock = new DataBlock("Chip Data",result.data_m0.length,result.testIndex);
        for(int i=0;i<blockSize;i++) {
          dataBlock.add(0,i,result.data_m0[i]);
          dataBlock.add(1,i,result.data_s1[i]);
          dataBlock.add(2,i,result.data_s2[i]);
          dataBlock.add(3,i,result.data_s3[i]);
          dataBlock.add(4,i,result.data_s4[i]);
          dataBlock.add(5,i,result.data_e5[i]);
          dataBlock.add(6,i,result.data_m8[i]);
          dataBlock.add(7,i,result.data_s9[i]);
          dataBlock.add(8,i,result.data_s10[i]);
          dataBlock.add(9,i,result.data_s11[i]);
          dataBlock.add(10,i,result.data_s12[i]);
          dataBlock.add(11,i,result.data_e13[i]);
          }
         testObject.add(dataBlock);
         // DCS
         DCSInfo dcsInfo = new DCSInfo();
         for(int i=0;i<8;i++) if(result.dcsinfo[i]!=SCTDBTestDownloader.NODATA) dcsInfo.put(i,result.dcsinfo[i]);
         testObject.add(dcsInfo);
         // Defects
         for(int i=0;i<result.noDefectChannels;i++) {
           String defectLine = result.defectList[i];
           Matcher matcher = defectPattern.matcher(defectLine);
           if(matcher.matches()) {
              DefectInfo defectInfo = new DefectInfo();
              defectInfo.setFirstChannel(defectLine.substring(matcher.start(1),matcher.end(1)));
              defectInfo.setLastChannel(defectLine.substring(matcher.start(2),matcher.end(2)));
              defectInfo.setName(defectLine.substring(matcher.start(3),matcher.end(3)));
              testObject.add(defectInfo);
              }
           else System.err.println("Unrecognised defect descriptor: "+defectLine);
           }
         // DAQ info
         DAQInfo daqInfo = new DAQInfo();
         for(int i=0;i<5;i++) daqInfo.put(i,result.daqInfo[i]);
         testObject.add(daqInfo);
         // Test Status
         TestInfo testInfo = new TestInfo();
         testInfo.setStatus(new Double(result.status));
         testObject.add(testInfo);
         cache.put(resultObject,testObject);
         return testObject;
         }catch(Exception e){System.err.println("SctGUI: Failed to extract "+resultObject+" : "+e.toString());}
         return null;
         }

     public Double getTestData(String resultObjectHeader, String serialNo,int testIndex, SummaryReader.DCSInfo dcsInfo) {
                  if(testIndex==-1) return null;
                  int parameterIndex = guiControl.selectorPane.getDisplayParameterIndex();
                  int option = guiControl.selectorPane.getMouseClickIndex();
                  if(parameterIndex<0) return null;
                  SummaryReader.Test testResult = getTest(resultObjectHeader,serialNo,dcsInfo);           
                  if(testResult==null) return null;
                  Double theData=null;
                  switch(guiControl.displayStatus.getStatus()) {
                     case DisplayStatus.IV_DATA:
                         switch(parameterIndex) {
                            case 0: // test status
                              theData = testResult.getTestInfo().getTestStatusData();
                              break;
                             case 1: // Current
                              theData = testResult.getIVData().getCurrent(option);  
                              break;
                             case 2:
                              dcsInfo = testResult.getDCSInfo();
                              if(dcsInfo!=null) theData = dcsInfo.get(option);
                              break;
                             }
                            break;
                      default:
                         switch(parameterIndex) {
                           case 0: // test status
                             theData = testResult.getTestInfo().getTestStatusData();
                             break;
                           case 1: // defect count
                             theData = testResult.noDefects();  
                             break;
                           case 2: // DCS conditions
                             dcsInfo = testResult.getDCSInfo();
                             if(dcsInfo!=null) theData = dcsInfo.get(option);
                             break;
                           default:
                             theData = (testIndex==TEST_RXTHRESHOLD || testIndex==TEST_RXDELAY) ? testResult.getLinkInfo().get(option) : testResult.getLastDataBlock().get(option,parameterIndex-3);
                             }
                       }
                   return theData;
                   }

     public SummaryReader.IVData getIVData(String resultObjectHeader,String serialNo) {

                  SummaryReader.Test testResult = getTest(resultObjectHeader,serialNo,null);           
                  if(testResult==null) return null;
                  else return testResult.getIVData();

                   }

 
    public Test getTest(String resultObjectHeader, String serialNo,SummaryReader.DCSInfo dcsInfo) {
             String resultObject = resultObjectHeader+serialNo;
             SummaryReader.Test testObject = (SummaryReader.Test)cache.get(resultObject);
             if(testObject!=null) return testObject;


             try {
               if(!Sct.IS.SctNames.getISRepository().contains(resultObject)) return null;
               TestSummaryIS result = new TestSummaryIS(); 
               Sct.IS.SctNames.getISRepository().getValue(resultObject, result); 
               SummaryReader.Reader reader = new SummaryReader.Reader(serialNo,result.dataString,dcsInfo);
               cache.put(resultObject,reader.getTest());
               return reader.getTest();
               }catch(Exception e){System.err.println("SctGUI: Failed to extract "+resultObject+" : "+e.toString());}
             return null;
             }


   public void fillDCSMap(String objectName) {
      ConfigurationInterface config = ConfigurationInterface.getInstance();
      if(!config.isDCSAvailable()) return;
      try {
      Map snMap = new HashMap();
      for(Enumeration e = config.getSerialNumberMap(guiControl.displayPane.getSCTView()).elements(); e.hasMoreElements();) {
           ModuleCell thisCell = (ModuleCell) e.nextElement();
           String sn = thisCell.getSerialNo();
           String dcsHeader = config.getSNInfo(sn,SNInfo.DCS_HEADER);
           if(dcsHeader==null) continue;
           SummaryReader.DCSInfo dcsInfo = new SummaryReader.DCSInfo();
	   String server =prefs.getPreference(prefs.DCS_SERVER_NAME);
           for(int i=0;i<dcsParams.length;i++) {
                String ISObject = server+"."+dcsHeader+dcsParams[i] + ".Recv";
                if(!Sct.IS.SctNames.getISRepository().contains(ISObject)) continue;
                is.AnyInfo theValue = new is.AnyInfo();
                Sct.IS.SctNames.getISRepository().getValue(ISObject, theValue);
                double theData = ((Float)theValue.getAttribute(theValue.getAttributeCount()-1)).doubleValue();
                dcsInfo.put(i,Double.parseDouble(nf.format(theData)));
                }
           snMap.put(sn,dcsInfo);
           }
       dcsMap.put(objectName,snMap);
      }catch(Exception e){System.err.println("SctGUI: Failed to extract DCS data");}

      }
   public Double getDCSData(String sn, int parameterIndex) {
         try {
         ConfigurationInterface config = ConfigurationInterface.getInstance();
         if(!config.isDCSAvailable()) return null;
         String dcsHeader = config.getSNInfo(sn,SNInfo.DCS_HEADER);
         if(dcsHeader==null) return null;	 
         String ISObject = prefs.getPreference(prefs.DCS_SERVER_NAME)+"."+dcsHeader+dcsParams[parameterIndex]+".Recv";
         if(!Sct.IS.SctNames.getISRepository().contains(ISObject)) return null;
         is.AnyInfo theValue = new is.AnyInfo();
         Sct.IS.SctNames.getISRepository().getValue(ISObject, theValue);
         double theData = ((Float)theValue.getAttribute(theValue.getAttributeCount()-1)).doubleValue();
	 return Double.valueOf(nf.format(theData));
	 }catch(Exception e){return null;}
	 }


    public Map getDCSMap(String controlObjectName) {
       return (Map)dcsMap.get(controlObjectName);
       }
    public void setCacheSize(int size) {
       cache = new guiUtilities.Cache(size);
       }
 



     private GuiComponents.System.ISInterface is;


}

