/*
 * ColorScalePoint.java
 *
 * Created on 26 June 2003, 14:34
 */

package DisplayGUI;
import java.awt.Color;

/**
 * Class to hold color scale point information
 * @author  robinson
 */
public class ColorScalePoint {
    Double value;                                         
    Color color;                                       
    String label;                                       


    /** Creates a new instance of colorScale with gradient colors */
    public ColorScalePoint(Double xlow, Color loColor, String loLabel) {
        value = xlow;
         color = loColor;
        label = loLabel;
    }
    public Color getColor() {
       return color;
       }
    public Double getValue() {
       return value;
       }
    public void setValue(Double value) {
       this.value=value;
       }
    public String getLabel() {
       return label;
       }
    public void setLabel(String label) {
       this.label=label;
       }
    public boolean equals(ColorScalePoint otherPoint) {
       if(!label.equals(otherPoint.getLabel())) return false;
       if(!value.equals(otherPoint.getValue())) return false;
       if(!color.equals(otherPoint.getColor())) return false;
       return true;
       }
    public void setData(int index, Object object) {
       switch(index) {
         case 0:
            value = (Double)object;
            break;
         case 1:
             label = (String)object;
            break;
          case 2:
             color = (Color) object;
          default:
          }
       }
    public Object getData(int index) {
       switch(index) {
         case 0:
            return value;
         case 1:
             return label;
          case 2:
             return color;
          default:
          }
       return null;
       }
}
