import org.omg.CORBA.IntHolder;
import ipc.*;

public class doAll {
    public static void main(String args[]) {
	//System.setProperty("ipc.ref.file", "/work/daq-1/installed/com/ipc_root.ref");
	Partition pt= new Partition("SCT");

	sctConf.Configuration h = null;

        try {
            org.omg.CORBA.Object obj = pt.lookup(sctConf.Configuration.serverName,
                                                 sctConf.Configuration.instanceName); 
            if (obj == null) System.out.println("Object " + sctConf.Configuration.serverName + " not found in server " + sctConf.Configuration.instanceName);
            h = sctConf.ConfigurationHelper.narrow(obj);
        } catch (org.omg.CORBA.BAD_PARAM bp) {
            System.err.println("Couldn't get api object: " + bp);
        } catch (org.omg.CORBA.COMM_FAILURE cf) {
            System.err.println("CORBA communications error: " + cf);
        } catch (java.lang.Exception e) {
            System.err.println("Other error" + e);
        }

	if (h==null) {
	    System.err.println("Error (check configuration server)");
	    return;
	}
        System.out.println("Found configuration");

        try {
            int[] parts = h.listPartitions();
            for(int p=0; p<parts.length; p++) {
                System.out.println("Partition " + p + " " + parts[p]);
                int[] crates = h.listCratesInPartition(parts[p]);
                for(int c=0; c<crates.length; c++) {
                    System.out.println("Crate " + c + " " + crates[c]);
                    int[] rods = h.listRodsInCrate(parts[p], crates[c]);
                    for(int r=0; r<rods.length; r++) {
                        System.out.println("Rod " + r + " " + rods[r]);
                        //                      sct.RodConfig rodConf = h.getRodConfig(parts[p], crates[c], rods[r]);
                        //                      System.out.println(rodConf.slaves[0].emifFile);

                        int[] MURs = h.listMURSInRod(parts[p], crates[c], rods[r]);
                        for(int mur=0; mur<MURs.length; mur++) {
                            System.out.println("MUR " + mur + " " + MURs[mur]);
                            String[] modules = h.listModulesInMUR(parts[p], MURs[mur]);

                            for(int m=0; m<modules.length; m++) {
                                System.out.println("Module " + m + " " + modules[m]);

                                IntHolder MUR = new IntHolder(), num = new IntHolder();
                                h.translateFromSN(modules[m], MUR, num);

                                IntHolder barrel = new IntHolder(), row = new IntHolder(), number = new IntHolder();
                                h.translateToBarrel(MUR.value, num.value, 
                                                    barrel, row, number);
                                System.out.println("Barrel " + barrel.value + " Row " + row.value + " Number " + number.value);
                            }
                        }
                    }
                }
            }
        } catch(sctConf.ConfigurationException e) {
            System.out.println("Java caught an exception!");
        }
    }
}
