#include "sctConf.hh"
#include <ipc/object.h>

int main(int argv, char** argc) {
  sctConfStatus status;	
  IPCPartition p("SCT");
  IPCObjectVar<sctConf_T_Configuration> handle = 
    p.lookup(sctConf_C_Configuration_instanceName, 
             sctConf_C_Configuration_serverName,
             sctConf_T_Configuration::ILUClassRecord);
  if (handle ==0 ) {
    std::cout << "Error" << std::endl;
    return -1;
  }
  status.returnCode = 0;
  sctConf_T_PartitionList myList = handle->listPartitions(&status);
  std::cout << "Code = " << status.returnCode << std::endl;
  std::cout << "Done get partition\n";

  unsigned long barrel, row;
  long number;

  status.returnCode = 0;
  handle->translateToBarrel(&status, 0, 1, &barrel, &row, &number);

  std::cout << "Code = " << status.returnCode << std::endl;
  if(status.returnCode != 0) {
    std::cout << "Translation exception\n";
  } else {
    std::cout << "Returned from translation\n";
    std::cout << "Barrel " << barrel << " " << row << " " << number << std::endl;

    for(unsigned int i=0; i<myList->Length(); i++) {
      std::cout << i << " " << myList->Nth(i) << std::endl;
    }
  }

  status.returnCode = 0;
  handle->saveConfiguration(&status, "config_client_dump.xml");
  //	cout << text <<endl;
}
