#include <iostream>
// #include <fstream>
#include <stdexcept>

#include <unistd.h>
#include <stdio.h> // For tempnam
#include "Sct/SctNames.h"

#include "log.h"

using namespace Sct;

Log::Log() {
  std::string fileName = getDefaultFileName();
  open(fileName.c_str(), std::ios::app);
  std::cout << "Log started to " << fileName << std::endl;
  printHeader();
}

Log::Log(std::string fname) : std::ofstream(fname.c_str(), std::ios::app) {
  std::cout << "Log started to \"" << fname.c_str() << "\"\n";
  printHeader();
  *this << "  logging to: \"" << fname << "\"" << std::endl;
}

Log::Log(std::string pref, int instance) {
  {
    char *tempName = tempnam(NULL, pref.c_str());
    std::cout << "Log started to file named something like \"" << tempName << "\"\n";
    open(tempName, std::ios::app);
    free(tempName);
  }
  printHeader();
  *this << "  logging to: \"" << pref << "\"" << std::endl;
}

Log::~Log() {
  if(std::uncaught_exception()) {
    *this << "Logging shut down due to exception\n";
  } else {
    *this << "Logging successfully shut down\n";
  }
  printTrailer();

  close();
}

std::string Log::getDefaultFileName() {
    std::string fileName = SctNames::getLogDir() + "/ConfigurationLog.log";
    return fileName;
}

void Log::printHeader() {
  *this << "  pid: " << (int)getpid() << "\n"; // << flush;
  time_t currTime = time(0);
  *this << "  at: " << ctime(&currTime) << std::endl;
}

void Log::printTrailer() {
  *this << "  pid = " << ((int)getpid()) << std::endl;
  time_t currTime = time(0);
  *this << "  at: " << ctime(&currTime) << std::endl;
}
