#include <iostream> 
#include <list>
#include <memory>

#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>

using namespace std;

#include "configXMLImpl.h"
using namespace SctConfiguration;

int main(int argc, char **argv) {
  std::auto_ptr<SctConfiguration::Configuration> conf(new ConfigurationXMLImpl);

  if(argc > 1) {
    conf->loadConfiguration(argv[1]);
  }

  SctConfiguration::Configuration &config=*conf;

  unsigned int totalPartitions = 0;
  unsigned int totalCrates = 0;
  unsigned int totalRods = 0;
  unsigned int totalModules = 0;

  try {
    list<unsigned int> partitions = config.listPartitions();

    for(list<unsigned int>::const_iterator p=partitions.begin();
        p!=partitions.end(); 
        p++) {
      list<unsigned int> crates = config.listCratesInPartition(*p);

      for(list<unsigned int>::const_iterator c=crates.begin(); 
          c!=crates.end(); 
          c++) {
        try {
          TimConfig tConf = config.getTimConfig(*p, *c);
        } catch(ConfigurationException &cx) {
          cout << "No TIM configuration for crate " << *p << " " << *c << endl;
        }

        list<unsigned int> rods = config.listRodsInCrate(*p, *c);

        for(list<unsigned int>::const_iterator r=rods.begin(); 
            r!=rods.end(); 
            r++) {
          RodConfig rodConf = config.getRodConfig(*p, *c, *r);

          {
            struct stat statBuf;
            int ret = stat(rodConf.slaves[0].idramFile.c_str(), &statBuf);

#warning "Probably need env subs"
//             if(ret)
//               perror("Error stating idramFile");
          }

          totalRods ++;
          list<unsigned int> MURs = config.listMURSInRod(*p, *c, *r);

          for(list<unsigned int>::const_iterator mur=MURs.begin(); 
              mur!=MURs.end(); 
              mur++) {
            list<string> modules = config.listModulesInMUR(*p, *mur);

            for(list<string>::const_iterator m=modules.begin(); 
                m!=modules.end(); 
                m++) {
              try {
                // ROD
                unsigned int partition, crate, rod, channel;

                // MUR
                unsigned int MUR, module;

                // Serial number
                std::string sn;

                // Barrel format
                unsigned int barrel, row;
                int number;

                int group = config.getModuleGroup(*m);
//                 cout << "Got module group = " << group << endl;

                // Endcap format
                int disk;
                unsigned int ring, eNumber;

                // Power supply
                unsigned int ppartition, pcrate, pchannel;

                config.translateFromSN(*m, MUR, module);
                config.translateToROD(MUR, module, partition, crate, rod, channel);
                config.translateToSN(MUR, module, sn);

                if(sn != *m) {
                  std::cout << " Serial number conversion mismatch!\n";
                }

                MUR = 100000;
                module = 100;

                config.translateFromROD(partition, crate, rod, channel, MUR, module);

                try {
                  BOCChannelConfig bocConf = config.getBOCConfig(*p, *c, *r, channel);
                } catch(ConfigurationException &cex) {
                  cout << "No BOCConfig for " << *p << " " << *c << " " << *r << " " << channel << "!\n";
                  cout << "\t" << cex.what() << endl;
                }

                try {
                  MURType type = config.getMURType(MUR);

                  switch(type) {
                  case BARREL:
                    barrel = 100, row = 100;
                    number = 100;
                    config.translateToBarrel(MUR, module, barrel, row, number);
                    break;
                  case ENDCAP:
                    disk = 100, ring = 100;
                    eNumber = 100;
                    config.translateToEndcap(MUR, module, disk, ring, eNumber);
                    break;
                  case UNMAPPED:
                    cout << "No physical translation for MUR " << MUR << " " << module << endl;
                    break;
                  case UNKNOWN:
                    cout << "MUR " << MUR << " of unkown type!\n";
                    break;
                  }
                } catch(ConfigurationException &c) {
                  cout << "No physical translation for MUR " << MUR << " " << module << endl;
                }

                try {
                  partition = 100;
                  crate = 100;
                  rod = 100;
                  channel = 100;
                  config.translateToRROD(MUR, module, partition, crate, rod, channel);

//                   cout << "From Redundant Rod: ";
                  config.translateFromRROD(partition, crate, rod, channel, MUR, module);
//                   cout << "MUR " << MUR << " " << "module " << module << endl;
                } catch(ConfigurationException &c) {
                  cout << "No redundant Rod mapping for " 
                       << MUR << " " << module << endl;
                }

                try {
                  config.translateToPowerSupply(MUR, module, ppartition, pcrate, pchannel);
                } catch(ConfigurationException &c) {
                  cout << "No power supply mapping... for (" << MUR << " " << module << ")\n";
                }
              } catch(ConfigurationException &c) {
                cout << "Unexpected exception doing tests on module translation\n -> " << c.what() << "\n";
              } 

              try {
//                 cout << "Module configuration for " << *m << ":\n";
                ABCDModule configuration = config.getModuleConfig(*m);
//                 cout << " Found module configuration\n";
//                 config.printModuleConfig(configuration);

//                 cout << " Get module string\n";
//                 cout << config.getModuleConfigurationString(*m, configuration).length() << endl;
//                 cout << config.getModuleConfigurationString(*m, configuration) << endl;
              } catch(ConfigurationException &c) {
                cout << "No module configuration found for " << *m << ":\n";
                cout << "\t" << c.what() << endl;
              }

              totalModules ++;
            }

            try {
              list<string> rmodules = config.listRModulesInMUR(*p, *mur);
            } catch(ConfigurationException &e) {
              cout << "Bad redundant modules for rod MUR " << *mur << endl;
            }
          }

          char *mappings = config.getFibreMappings(*p, *c, *r);

          delete [] mappings;
        }
        totalCrates++;
      }
      totalPartitions ++;
    }

    list<string> modules = config.listAllModules();

    list<string> uModules = config.listUnusedModules();

    if(uModules.size() > 0)
      cout << "Configuration provided for " << uModules.size() << " modules that aren't linked into ROD hierarchy\n";

  } catch(ConfigurationException &c) {
    cout << "Bad configuration somewhere " << c.what() << "\n"; 
  }

  cout << "*** Configuration object counts ***\n";
  cout << "\ttotalPartitions: " << totalPartitions << endl;
  cout << "\ttotalCrates: " << totalCrates << endl;
  cout << "\ttotalRods: " << totalRods << endl;
  cout << "\ttotalModules: " << totalModules << endl;
}
