/*
 * ISHistogram2DAdapter.java
 *
 * Created on 27 November 2002, 18:14
 */

package oh.aida;
import oh.*;
import hep.aida.*;


/**
 *
 * @author  palmer
 */
public class ISHistogram2DAdapter extends ISHistogramAdapter implements IHistogram2D {
    
    /** Creates a new instance of ISHistogram2DAdapter */
    public ISHistogram2DAdapter(ISHistogram2D data) {
        super(data);
    }
    
    public void add(hep.aida.IHistogram2D iHistogram2D) throws java.lang.IllegalArgumentException {
        unimplementedFunction();
    }
    
    public int binEntries(int param, int param1) throws java.lang.IllegalArgumentException {
        return 0;
    }
    
    public int binEntriesX(int param) throws java.lang.IllegalArgumentException {
        return 0;
    }
    
    public int binEntriesY(int param) throws java.lang.IllegalArgumentException {
        return 0;
    }
    
    public double binError(int param, int param1) throws java.lang.IllegalArgumentException {
        return _binError(index(param, param1));
    }
    
    public double binHeight(int param, int param1) throws java.lang.IllegalArgumentException {
        return _binHeight(index(param, param1));
    }
    
    public double binHeightX(int param) throws java.lang.IllegalArgumentException {
        unimplementedFunction();
        return 0;
    }
    
    public double binHeightY(int param) throws java.lang.IllegalArgumentException {
        unimplementedFunction();
        return 0;
    }
    
    public double binMeanX(int param, int param1) throws java.lang.IllegalArgumentException {
        unimplementedFunction();
        return 0;
    }
    
    public double binMeanY(int param, int param1) throws java.lang.IllegalArgumentException {
        unimplementedFunction();
        return 0;
    }
    
    public int coordToIndexX(double param) {
        unimplementedFunction();
        return 0;
    }
    
    public int coordToIndexY(double param) {
        unimplementedFunction();
        return 0;
    }
    
    public void fill(double param, double param1) throws java.lang.IllegalArgumentException {
        unimplementedFunction();
    }
    
    public void fill(double param, double param1, double param2) throws java.lang.IllegalArgumentException {
        unimplementedFunction();
    }
    
    public double meanX() {
        return ((ISHistogram2D)data).is_xmean;
    }
    
    public double meanY() {
        return ((ISHistogram2D)data).is_ymean;
    }
    
    public double rmsX() {
        return ((ISHistogram2D)data).is_xrms;
    }
    
    public double rmsY() {
        return ((ISHistogram2D)data).is_yrms;
    }
    
    public hep.aida.IAxis xAxis() {
        return new AxisAdapter(0);
    }
    
    public hep.aida.IAxis yAxis() {
        return new AxisAdapter(1);
    }
    
    
    /**
     * Helpful functions
     */
    
    /**
     * Returns the index into the bins array.  Need to add 1 to most indexes because
     * bin 0 is the underflow
     */
    protected int index(int indexX, int indexY )  {
        int bcx = xAxis().bins();
        int bcy = yAxis().bins();
        if ( indexX == IAxis.OVERFLOW_BIN ) indexX = bcx + 1;
        else if ( indexX == IAxis.UNDERFLOW_BIN ) indexX = 0;
        else indexX++;
        if ( indexY == IAxis.OVERFLOW_BIN ) indexY = bcy + 1;
        else if ( indexY == IAxis.UNDERFLOW_BIN ) indexY = 0;
        else indexY++;
        
        return indexX + indexY * ( bcx + 2 );
    }

}
