package is;

/**
 * This class carefully breaks IS type checking!
 * Overrides the getValue method and doesn't do any type checking...
 * User is responsible for getting it right!
 */
public class SctRepository extends Repository {
    protected ipc.Partition p;
    
    public SctRepository() {
        this(new ipc.Partition());
    }
    
    public SctRepository(ipc.Partition p) {
        super(p);
        this.p = p;
    }
    
    public void getValue (String name, Info info) throws  is.RepositoryNotFoundException, is.InfoNotFoundException, is.InfoNotCompatibleException {
        is.repository rep = is.Repository.resolve(p, name);

        org.omg.CORBA.StringHolder data = new org.omg.CORBA.StringHolder();

        try {
            rep.find( name, data );
        } catch (org.omg.CORBA.COMM_FAILURE ex) {
            throw new is.RepositoryNotFoundException();
        } catch (is.NotFound ex) {
            throw new is.InfoNotFoundException();
        }

        info.refreshGuts(new is.Istream(data.value));
}

}