#ifndef Archiving_H
#define Archiving_H

#include <string>

#include "SctData/ScanResult.h"
#include "SctData/RawScanResult.h"
#include "SctData/FitScanResult.h"
#include "Sct/SctNames.h"
#include <is/isinfo.h>

using namespace SctData;
using namespace Sct;


class Archiving  {
  
  protected:
  
  
    

  public:
    
  
    Archiving();
    virtual ~Archiving();
    //virtual Archiving* clone(shared_ptr<ScanResult> scan) = 0;
    virtual void Save() = 0;
    

    void ListISObj();
    void DeleteISObj(char* objName);     
    void SetUNIXDir();  
    
    
    ISInfoIterator* SetupRawIS(); 
    ISInfoIterator* SetupFitIS();
    
    
    ISInfoIterator* SetupNoiseOccupancyTestIS();
    ISInfoIterator* SetupNPtGainTestIS();
    ISInfoIterator* SetupStrobeDelayTestIS();
    ISInfoIterator* SetupTrimRangeTestIS();
    ISInfoIterator* SetupPipelineTestIS();
    ISInfoIterator* SetupTimeWalkTestIS();
    ISInfoIterator* SetupFullBypassTestIS();
    ISInfoIterator* SetupNMaskTestIS();

    
    string GetRawISUniqueID(unsigned int runNumber, unsigned int scanNumber, const string& moduleName);
    string GetFitISUniqueID(unsigned int runNumber, unsigned int scanNumber, const string& moduleName);

    IPCPartition* GetPartition();
    shared_ptr<Serializable> ISRetrieveObj(ISInfoIterator& ); 
    shared_ptr<Serializable> ISRetrieveObj(const string& SerISName ); 
    shared_ptr<ScanResult> ISRetrieveScanResult(const string& ScanISName );  
    shared_ptr<ScanResult> ISRetrieveScanResult(ISInfoIterator& ); 
    shared_ptr<RawScanResult> ISRetrieveRawScanResult(const string& RawISName);
    shared_ptr<RawScanResult> ISRetrieveRawScanResult(ISInfoIterator& );
    shared_ptr<FitScanResult> ISRetrieveFitScanResult(const string& FitISName );  
    shared_ptr<FitScanResult> ISRetrieveFitScanResult(ISInfoIterator& ); 
    
    //bool IsFitOver(char* scanName);

    void ISSendPersScanResult(RawScanResult &); //it might become virtual
    void ISSendPersScanResult(FitScanResult &);   //it might become virtual
    
    //To Do: string* getData(string ModuleName,string runNo,string ScanNo,string testName,string testParameter); 

    bool IsTestInIndex(unsigned int runNumber, string moduleName, string testType);
    bool IsTestInIndex(string runID, string moduleID, string testType);
    bool IsScanInIndex(unsigned int runNumber, string moduleName, string testType, unsigned int scanNumber);
    bool IsScanInIndex(string runID, string moduleID, string testType, string scanID);
    void UpdateTestIndex();
    void UpdateScanIndex();   

    void AddScanToIndex(string runID, string moduleID, string testTypeID, string scanID ); //Similar version of the one in ArchScanResult
    void AddTestToIndex(string runID, string moduleID, string testTypeID); //Similar version of the one in ArchTestResult


    string getTestSummaryFromArchive(unsigned int runNumber, string moduleName, string testType); //This should go to ArchRead 
    string getTestSummaryFromArchive(string runID, string moduleID, string testType); //This should go to ArchRead 
    vector<string> ListOfModulesWithinTestInIndex(string testType); //This should go to ArchRead 
    vector<string> ListOfModulesWithinTestInIndex(unsigned int runNumber, string testType); //This should go to ArchRead 
    string getModuleNameFromIndex(string indexLine);//This should go to ArchRead 
    string getRunNumberFromIndex(string indexLine);//This should go to ArchRead 
    vector<string> ListOfRunsInIndex(); //This should go to ArchRead
};


#endif
