#ifndef ArchTrimRangeTestResult_H
#define ArchTrimRangeTestResult_H

#include "Sct/SctNames.h"
#include "ArchTestResult.h"
#include "SctData/TrimRangeTestResult.h"
#include <vector>
#include <boost/shared_ptr.hpp>

class TGraph;

using boost::shared_ptr;
using namespace SctData;
using namespace Sct;


class ArchTrimRangeTestResult: public ArchTestResult  {
  
 private:
  vector<TGraph*> chipTrim; //ChipTrimData 
  vector<TF1*> chipTrimFit; //ChipTrimData Fit
  
  static bool inMap;
  
  ArchTrimRangeTestResult(shared_ptr<TrimRangeTestResult>);

 public:

  ArchTrimRangeTestResult();
  virtual shared_ptr<ArchTestResult> clone(shared_ptr<TestResult> test) {
                                   shared_ptr<TrimRangeTestResult> TRtest = dynamic_pointer_cast<TrimRangeTestResult>(test);
                                   return shared_ptr<ArchTestResult>(new ArchTrimRangeTestResult(TRtest));
  } 
  ~ArchTrimRangeTestResult();
 
  void SaveTrimRangeTestDataOnly();
  void Save();  
  
  void TestSummary(shared_ptr<TrimRangeTestResult>);

};


#endif
