#ifndef ArchTimeWalkTestResult_H
#define ArchTimeWalkTestResult_H


#include "Sct/SctNames.h"
#include "ArchTestResult.h"
#include "SctData/TimeWalkTestResult.h"
#include <TVectorD.h>
#include <vector>
#include <boost/shared_ptr.hpp>


using boost::shared_ptr;
using namespace SctData;
using namespace Sct;


class ArchTimeWalkTestResult: public  ArchTestResult {
  
 private:
  vector<float> timewalk;
  vector<float> calibration;

  vector< shared_ptr<TVector> > v_timewalk; 
  vector< shared_ptr<TVector> > v_calibration;
 
  static bool inMap;

  ArchTimeWalkTestResult(shared_ptr<TimeWalkTestResult>);

 public: 

  ArchTimeWalkTestResult();
  virtual shared_ptr<ArchTestResult> clone(shared_ptr<TestResult> test) {
                                   shared_ptr<TimeWalkTestResult> TWtest = dynamic_pointer_cast<TimeWalkTestResult>(test);
                                   return shared_ptr<ArchTestResult>(new ArchTimeWalkTestResult(TWtest));
  } 
  ~ArchTimeWalkTestResult();
 
  void SaveTimeWalkTestDataOnly();
  void Save();
  void TestSummary(shared_ptr<TimeWalkTestResult>);
   
};


#endif
