#ifndef ARCHIVINGSERVICE_H
#define ARCHIVINGSERVICE_H

#include <memory>
#include <is/isinfo.h>
#include "Archiving.hh"

namespace SctArchivingService {

class ArchivingWorkerGroup;
    
class ArchivingService : public IPCObject, public Archiving_T_ArchivingService {
public:
    ArchivingService();
    void run();
    static void testDataISCallback(ISCallbackInfo * isc);
    static void controlDataISCallback(ISCallbackInfo * isc);
    static void rawScanResultISCallback(ISCallbackInfo * isc);
    static void fitScanResultISCallback(ISCallbackInfo * isc);
    static IPCServer& server();
    void archive(ISCallbackInfo * isc);
    
    static ArchivingService& instance();
    static ArchivingService& initialize();

    //IPC methods
    virtual ilu_T_CString ping (ArchivingStatus *_status);
    
private:
    std::auto_ptr<ISInfoReceiver> infoReceiver;     ///<IS InfoReceiver for IS events
    ArchivingWorkerGroup* group;
    static ArchivingService* service;
    bool scanSavedFlag;
};

}

#endif //#ifndef ARCHIVINGSERVICE_H
