#include "Service.h"
#include "Sct/IpcObjectException.h"

#include <pmg/pmg_initSync.h>

using namespace SctArchivingService;

void pmgSynch(void *) {
    pmg_initSync();
}

int main(int argc, char** argv) {
    Sct::setExceptionHandlers(argv[0]);

    bool multiThreaded = false; //Choose single/multi-threaded 
    IPCCore::init(multiThreaded); 
    ArchivingService& arch=ArchivingService::instance();

    try {
        if (!arch.publish()) {
            throw Sct::IpcObjectException("Failed to publish ArchivingService", __FILE__, __LINE__);
        }

        arch.server().doSoon(pmgSynch, NULL);
	arch.run();
	arch.server().run();
	arch.withdraw();
    } catch (Sct::Throwable& e){
        e.sendToMrs(MRS_FATAL);
        std::terminate();
    }
}
