package TestGUI;

import java.io.*;
import java.util.*;
import javax.swing.*;
import javax.swing.tree.*;
import javax.swing.text.*;
import is.*;
import Sct.Serializable;
import Sct.IS.*;
import GuiComponents.Inspector.InspectorPanel;
import GuiComponents.plotter.*;
import GuiComponents.System.*;
import GuiComponents.Console.*;

/*
 * ISPanel.java
 *
 * Created on 25 April 2003, 13:41
 */

/**
 *
 * @author  palmer
 */
public class ISPanel extends javax.swing.JPanel implements InfoListener {
    
    /** Creates new form ISPanel */
    public ISPanel(JTextArea taMessages) {
        this.taMessages = taMessages;
        si = SystemInterface.getInstance();
        is = ISInterface.getInstance();
        initComponents();
        myInitComponents();
    }
    
    void close() {
        unsubscribeAll();
    }
    
    private void myInitComponents() {
        refreshISTree(false);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;
        
        lList = new javax.swing.JLabel();
        bDelete = new javax.swing.JButton();
        bISRefresh = new javax.swing.JButton();
        jScrollPane2 = new javax.swing.JScrollPane();
        jPanel2 = new javax.swing.JPanel();
        trISServers = new javax.swing.JTree();
        trISServers.getPreferredScrollableViewportSize();
        
        jSeparator1 = new javax.swing.JSeparator();
        bISData = new javax.swing.JButton();
        bExternal = new javax.swing.JButton();
        jLabel2 = new javax.swing.JLabel();
        bInternal = new javax.swing.JButton();
        bDeleteAll = new javax.swing.JButton();
        bIsdump = new javax.swing.JButton();
        
        setLayout(new java.awt.GridBagLayout());
        
        lList.setText("List of available IS servers and objects");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(lList, gridBagConstraints);
        
        bDelete.setText("Delete");
        bDelete.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bDeleteActionPerformed(evt);
            }
        });
        
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(bDelete, gridBagConstraints);
        
        bISRefresh.setText("Refresh");
        bISRefresh.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bISRefreshActionPerformed(evt);
            }
        });
        
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(bISRefresh, gridBagConstraints);
        
        jScrollPane2.setMinimumSize(new java.awt.Dimension(200, 100));
        jPanel2.setLayout(new javax.swing.BoxLayout(jPanel2, javax.swing.BoxLayout.Y_AXIS));
        
        jPanel2.setMinimumSize(new java.awt.Dimension(200, 200));
        trISServers.setBorder(new javax.swing.border.EtchedBorder());
        trISServers.setMaximumSize(new java.awt.Dimension(32767, 32767));
        trISServers.setAutoscrolls(true);
        trISServers.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                trISServersKeyReleased(evt);
            }
        });
        trISServers.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                trISServersMouseClicked(evt);
            }
        });
        
        jPanel2.add(trISServers);
        
        jScrollPane2.setViewportView(jPanel2);
        
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 12;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(jScrollPane2, gridBagConstraints);
        
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(jSeparator1, gridBagConstraints);
        
        bISData.setText("IS Data");
        bISData.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bISDataActionPerformed(evt);
            }
        });
        
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(bISData, gridBagConstraints);
        
        bExternal.setText("External Graphics");
        bExternal.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bExternalActionPerformed(evt);
            }
        });
        
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(bExternal, gridBagConstraints);
        
        jLabel2.setText("View...");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        add(jLabel2, gridBagConstraints);
        
        bInternal.setText("Internal Graphics");
        bInternal.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bInternalActionPerformed(evt);
            }
        });
        
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(bInternal, gridBagConstraints);
        
        bDeleteAll.setText("Delete All");
        bDeleteAll.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bDeleteAllActionPerformed(evt);
            }
        });
        
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(bDeleteAll, gridBagConstraints);
        
        bIsdump.setText("IS Dump");
        bIsdump.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bIsdumpActionPerformed(evt);
            }
        });
        
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(bIsdump, gridBagConstraints);
        
    }//GEN-END:initComponents

    private void bIsdumpActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bIsdumpActionPerformed
        TreePath[] paths = trISServers.getSelectionPaths();        
        for (int i=0; i<paths.length; i++) {           
            dumpISData(paths[i].getLastPathComponent().toString());            
        }   
    }//GEN-LAST:event_bIsdumpActionPerformed

    private void bDeleteAllActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bDeleteAllActionPerformed
        ServerIterator sit = new ServerIterator(si.getPartition());
        while (sit.hasMoreElements()) {            
            InfoList il = new InfoList(si.getPartition(), sit.nextServerName());
            for (int i=0; i<il.size(); ++i) {
                is.remove(il.getInfo(i).getName());
            }
        }
    }//GEN-LAST:event_bDeleteAllActionPerformed
    
    
    private void bInternalActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bInternalActionPerformed
        TreePath[] paths = trISServers.getSelectionPaths();        
        for (int i=0; i<paths.length; i++) {           
            plotISData(paths[i].getLastPathComponent().toString());            
        }                
    }//GEN-LAST:event_bInternalActionPerformed

    private void bExternalActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bExternalActionPerformed
        TreePath[] paths = trISServers.getSelectionPaths();        
        for (int i=0; i<paths.length; i++) {           
            launchExternalViewer(paths[i].getLastPathComponent().toString());            
        }
    }//GEN-LAST:event_bExternalActionPerformed

    private void bISDataActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bISDataActionPerformed
        TreePath[] paths = trISServers.getSelectionPaths();        
        for (int i=0; i<paths.length; i++) {           
            viewISData(paths[i].getLastPathComponent().toString());            
        }
    }//GEN-LAST:event_bISDataActionPerformed

    private void trISServersKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_trISServersKeyReleased
        switch (evt.getKeyCode()) {
            case java.awt.event.KeyEvent.VK_DELETE: //Remove selected objects
                deleteSelectedInfos();
                break;
            default: //Do nothing
        }
    }//GEN-LAST:event_trISServersKeyReleased

    private void trISServersMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_trISServersMouseClicked
        int selRow = trISServers.getRowForLocation(evt.getX(), evt.getY());
        TreePath selPath = trISServers.getPathForLocation(evt.getX(), evt.getY());
        if(selRow != -1) {
            if(evt.getClickCount() == 2) {
                String name = selPath.getLastPathComponent().toString();
                //histPlotter.plotHistogram(hist, "Canvas 1");
                viewISData(name);
            }
        }
    }//GEN-LAST:event_trISServersMouseClicked

    private void bCreateTrimRangeTestActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bCreateTrimRangeTestActionPerformed

    }//GEN-LAST:event_bCreateTrimRangeTestActionPerformed
    
    private void bISRefreshActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bISRefreshActionPerformed
        refreshISTree(true);
    }//GEN-LAST:event_bISRefreshActionPerformed

    private void bDeleteActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bDeleteActionPerformed
        deleteSelectedInfos();
    }//GEN-LAST:event_bDeleteActionPerformed

    private void plotISData(String name) {
        if (plotterManager == null)
            initPlotterManager();
        
        try {
            Serializable ob = ObjectManagerIS.getInstance().readObject(name);
            plotterManager.plot(ob);
            
        } catch (java.io.IOException ioe) {
            taMessages.append("Error reading object from IS: " + ioe + "  " +ioe.getMessage() +"\n");
        }
        taMessages.append("IS Object: " + name + " plotted\n");      
    }
    
    private void initPlotterManager() {
        plotterManager = PlotterManager.defaultManager();
        JFrame frame = new JFrame("Plots");
        frame.getContentPane().add(plotterManager.getPlotPanel());
        frame.pack();
        frame.show();
    }
    
    private void viewISData(String name) {
        try {
            Serializable ob = ObjectManagerIS.getInstance().readObject(name);
            InspectorPanel p = new InspectorPanel(name, ob);

            JFrame frame2 = new JFrame("TreeTable");                    
            frame2.getContentPane().add(new JScrollPane(p.treeTable));
            frame2.pack();
            frame2.show();

        } catch (java.io.IOException ioe) {
            taMessages.append("Error reading object from IS: " + ioe + "  " +ioe.getMessage() +"\n");
        }
        taMessages.append("IS Object: " + name + " viewed\n");
    }
    
    private void dumpISData(String name) {
        try {
            AnyInfo ai = new AnyInfo();
            is.getRepository().getValue(name, ai);
            InspectorPanel p = new InspectorPanel(name, new Sct.IS.AnyInfoAdapter(ai));

            JFrame frame2 = new JFrame("TreeTable");                    
            frame2.getContentPane().add(new JScrollPane(p.treeTable));
            frame2.pack();
            frame2.show();

        } catch (Exception ioe) {
            taMessages.append("Error reading object from IS: " + ioe + "  " +ioe.getMessage() +"\n");
        }
        taMessages.append("IS Object: " + name + " dumped\n");
    }
    
    private void launchExternalViewer(String name) {
	try {
	    ExternalProcess p = new ExternalProcess("DataDisplayer " + name);                                    
	} catch (Exception ioe) {
	    System.out.println(ioe.getMessage());
	    ioe.printStackTrace();
	}	
    }

     /**
     *Refreshes the list of servers and their members
     */
    /**
     * Will there be thread problems here?
     */
    protected void refreshISTree(boolean unsubscribe) {  
        if (unsubscribe) unsubscribeAll();
        String[] servers = is.getISServers();        
        
        //Setup tree
        
        DefaultMutableTreeNode top = new DefaultMutableTreeNode("IS Servers");
        DefaultMutableTreeNode server;
        DefaultMutableTreeNode object;
        for (int i=0; i<servers.length; i++) {
            is.subscribe(servers[i], this);
            server = new DefaultMutableTreeNode(servers[i]);
            String[] objects = is.getISObjects(servers[i]);
            for (int j=0; j<objects.length; j++) {
                object = new DefaultMutableTreeNode(objects[j]);
                server.add(object);
            }
            top.add(server);
        }
        trISServers.setModel(new DefaultTreeModel(top));
    }
    
    /**
     * Unsubscribe all ISServers
     */
    protected void unsubscribeAll() {
        TreeModel model = trISServers.getModel();
        Object root = model.getRoot();
        for (int i=0; i<model.getChildCount(root); ++i) {            
            is.unsubscribe(model.getChild(root, i).toString());
        }
    }
    /**
     * Deletes the selected objects from the IS repository
     */
    private void deleteSelectedInfos() {        
        TreePath[] paths = trISServers.getSelectionPaths();
        String object;
        for (int i=0; i<paths.length; i++) {
            object = paths[i].getLastPathComponent().toString();
            taMessages.append(is.remove(object) + "\n");
        }
    }
    
    /** InfoListener interfaces
     */ 
    
    /**
     * Adds the new object to the tree
     */
    public void infoCreated(InfoEvent e) {
       String serverName = e.getName().split("\\.")[0];
       DefaultMutableTreeNode server = null;
       for (int i=0; i<trISServers.getModel().getChildCount(trISServers.getModel().getRoot()); i++) {
            server = (DefaultMutableTreeNode)trISServers.getModel().getChild(trISServers.getModel().getRoot(), i);
            if (server.toString().equals(serverName)) { //found the appropriate server
                String name = new String(e.getName());      //Copy name object
                DefaultMutableTreeNode newobject = new DefaultMutableTreeNode(name);

                //Handles message creation for us so thread safe
                ((DefaultTreeModel)trISServers.getModel()).insertNodeInto(newobject, server, server.getChildCount());
                return;
            }
        }
        System.err.println("Server: " + serverName + " not found");
    }
    
    /**
     * Removes the object from the tree     
     */
    public void infoDeleted(InfoEvent e) {        
        TreePath path = trISServers.getNextMatch(new String(e.getName()), 0, Position.Bias.Forward );
        if (path == null) {
            System.out.println(e.getName() + " not found in tree");
            return;
        }
        DefaultMutableTreeNode hist = (DefaultMutableTreeNode)path.getLastPathComponent();                
        
        //This call handles message creation for us so can be called in any thread.
        ((DefaultTreeModel)trISServers.getModel()).removeNodeFromParent(hist);        
    }
    
    /**
     * Does nothing - object is still there - maybe should mark it somehow?
     */
    public void infoUpdated(InfoEvent e) {
        taMessages.append(new String(e.getName()) + " has been updated\n");
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton bDelete;
    private javax.swing.JButton bDeleteAll;
    private javax.swing.JButton bExternal;
    private javax.swing.JButton bISData;
    private javax.swing.JButton bISRefresh;
    private javax.swing.JButton bInternal;
    private javax.swing.JButton bIsdump;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JLabel lList;
    private javax.swing.JTree trISServers;
    // End of variables declaration//GEN-END:variables
    private SystemInterface si;
    private ISInterface is;
    private JTextArea taMessages;
    private PlotterManager plotterManager;
}
