#include "../src/WorkerGroup.h"
#include "MyWorkerGroup.h"

#include "ipc/core.h"
#include "Observer.hh"

using namespace SctService;
using namespace boost;
using namespace std;
using namespace Sct;

/*
   IPC test program exercises many aspects of the Worker/Observer pattern.
   uses the conrete classes defined in MyWorkerGroup.h
   @author Alan Barr @date 16 July 2003
*/

/*
  IPC object listener provides interface to outside world, and creates a MyWorkerGroup
  in its constructor
*/

class Listener : public IPCObject, public virtual Observer_T_ObserverInterface {
public:
    // constructor
    Listener(char* objid, IPCServer *ipcServer)
	: IPCObject(objid, ipcServer), server (ipcServer) {}
    
    virtual void ipcPause(ObserverStatus* status, unsigned char value) throw(){
	workergroup.setPaused(value);
	status->returnCode=ObserverReply_Success;
    }
    virtual void ipcAdd(ObserverStatus* status, ilu_Integer data){
	shared_ptr<MyClass> ptr(new MyClass(data));
	workergroup.push(ptr);
	status->returnCode=ObserverReply_Success;
    }
    virtual void ipcStop(ObserverStatus* status){
	workergroup.stop();
	status->returnCode=ObserverReply_Success;
	this->withdraw();
	server->stop();
    }
    virtual ilu_ShortInteger ipcBusy(ObserverStatus* status){
	unsigned n=workergroup.busy();
	status->returnCode=ObserverReply_Success;
	return n;
    }
    virtual ilu_ShortInteger ipcQueueSize(ObserverStatus* status){
	unsigned n=workergroup.queueSize();
	status->returnCode=ObserverReply_Success;
	return n;
    }
    virtual ilu_ShortInteger ipcNWorkers(ObserverStatus* status){
	unsigned n=workergroup.nWorkers();
	status->returnCode=ObserverReply_Success;
	return n;
    }

    // has a public worker group
    MyWorkerGroup workergroup;
    IPCServer* server;
};

int main(int argc, char** argv){
    setExceptionHandlers(argv[0]);
    
    //Set up the Listener over IPC:

    auto_ptr<IPCPartition> partition ( new IPCPartition("SCT") );
    auto_ptr<IPCServer> server ( new IPCServer("TestListenerServer", *partition) );
    auto_ptr<Listener> listener ( new Listener("TestListener", server.get()) ) ;
    
    // start the worker threads:

    listener->workergroup.go(4);

    // give it some data:
    
    for (int i=0; i<5; ++i){
	listener->workergroup.push(shared_ptr<MyClass>(new MyClass(i)) );
    }
    
    cout << "started Listener with number of workers = " << listener->workergroup.nWorkers() 
	 << " queue size = " << listener->workergroup.queueSize()
	 << " busy = " << listener->workergroup.busy() << endl;
    
    // publish the listener:
    
    if (!listener->publish()){
	cerr << "failed to publish listener"<<endl;
    }
    
    // now listen out for requests (including new data) over IPC:

    server->run();
}
