#include "DisplayManager.h"
#include "DisplayInfo.h"
#include "Exceptions.h"
#include "Displayer.h"
#include "Sct/Serializable.h"
#include "Sct/LogicErrors.h"
#include "TROOT.h"
#include "TCanvas.h"
#include "TSeqCollection.h"

using namespace Sct;

namespace SctDataDisplay {
    
DisplayManager::DisplayManager() {
  m_batchMode=false;
}

DisplayManager& DisplayManager::instance() {
    static DisplayManager disp;
    return disp;
}

bool DisplayManager::addToMap(string className, shared_ptr<Displayer> displayer) {
    if (instance().displayerMap.find(className) != instance().displayerMap.end()) return false;
    instance().displayerMap[className] = displayer;
    return true;
}

shared_ptr<DisplayData> DisplayManager::display(shared_ptr<const Serializable> ob, const DisplayInfo& info, std::ostream& os) {
    if (!ob) 
        throw InvalidArgumentError("Passed a null pointer to DisplayManager::display", __FILE__, __LINE__);

    if (instance().displayerMap.find(ob->getClassName()) == instance().displayerMap.end()) {
        for (unsigned int i=0; i<instance().genericList.size(); ++i) {
            if (instance().genericList[i]->canDisplay(*ob))
                return instance().genericList[i]->display(ob, info, os);
        }

	throw NoDisplayerException("No Displayer for class: " + ob->getClassName(), __FILE__, __LINE__);
    }

    return instance().displayerMap[ob->getClassName()]->display(ob, info, os);
}


bool DisplayManager::addGeneric(shared_ptr<GenericDisplayer> generic) {
    instance().genericList.push_back(generic);
    return true;
}

  bool DisplayManager::batchMode(){
    return instance().m_batchMode;
  }

  std::string DisplayManager::getOutputDir(){
     if (instance().m_outputdir=="") return instance().m_outputdir;
     return instance().m_outputdir + "/";
  }

  void DisplayManager::setOutputDir(const std::string& s){
       instance().setBatchMode();
       std::cout << "OUTPUT=" << s << std::endl;
       instance().m_outputdir=s;
  }

  void DisplayManager::setBatchMode(bool b){
    instance().m_batchMode=b;
  }
  
  void DisplayManager::OutputCanvases(){
    
    TSeqCollection* list = gROOT->GetListOfCanvases();
    for (int i=0; i<=list->LastIndex(); ++i){
      TCanvas* canvas=static_cast<TCanvas*>(list->At(i));
      string filename=getOutputDir() + canvas->GetName() + ".eps";
      
      while (true) {
	unsigned ipos=filename.rfind(' ');
	if (ipos==string::npos) break;
	filename[ipos]='_';
      }
      std::cout << "FILE " << filename << std::endl;
      canvas->Print((filename).c_str());
    }
  }

}
