#include <ipc/object.h>
#include <ipc/server.h>
#include <pmg/pmg_initSync.h>

#include <boost/bind.hpp>
#include <boost/lexical_cast.hpp>
#include <boost/shared_ptr.hpp>
#include <boost/thread.hpp>

#include "SctApi/SctApi.h"
#include "sctConf/configipc.h"

#include "SctApiServer.h"

std::auto_ptr<IPCServer> ipcServer; 

void dcsPollThread(SctApi::SctApi *sctApi);

void pmgSynch(void *) {
    pmg_initSync();
}

int main(int argc, char** argv) 
{
  IPCCore::init(true, false); // Try reentrant for DDC IS callbacks
  IPCPartition p("SCT");
  ipcServer.reset(new IPCServer(Sct_SctApi_C_SctApi_serverName, p));
  try {    
    std::auto_ptr<SctApi::SctApi> api(new SctApi::SctApi(boost::shared_ptr<SctConfiguration::Configuration>(new SctConfiguration::ConfigIPC)));
    std::auto_ptr<SctApiServer> h(new SctApiServer(*api, Sct_SctApi_C_SctApi_instanceName, ipcServer.get()));

    // Try publishing it
    if (!h->publish()) {
      std::cout << "Failed to publish SctApi" << std::endl;
      return 0;
    } 

    std::cout << "Serving...\n";

    boost::thread dcsThread(boost::bind(&dcsPollThread, api.get()));

    ipcServer->doSoon(pmgSynch, NULL);
    ipcServer->run();
    std::cout << "Run over" << std::endl;
    h->withdraw();
//    delete ipcServer;
  } catch(SctConfiguration::ConfigurationException &c) {
    std::cout << "ConfigurationException: " << c.what() << std::endl;

    MRSStream mrsStream(p);
    mrsStream << "SCTAPI_FAIL" << MRS_FATAL << MRS_QUALIF("SctApiServer") << MRS_TEXT("Configuration server not running!") << ENDM;
    
    exit(1);
  }
}

void dcsPollThread(SctApi::SctApi *sctApi) {
  // Let everything settle down first
  sleep(3);

  IPCPartition partition("SCT");

  ISInfoDictionary isDict(partition);

  while(1) {
    std::cout << "Polling BOC DCS\n";

    std::list<SctApi::RodLabel> rodList = sctApi->listRods();

    std::string isBaseName("SCTAPIServer.BOC_DCS");

    for(std::list<SctApi::RodLabel> ::const_iterator rodI = rodList.begin();
	rodI != rodList.end();
	rodI ++) {
      std::vector<double> thisMonitor 
	= sctApi->getBOCMonitorArray(rodI->partition, rodI->crate, rodI->rod);

      std::string isRodName(isBaseName
			    + "." + boost::lexical_cast<std::string>(rodI->partition) 
			    + "." + boost::lexical_cast<std::string>(rodI->crate) 
			    + "." + boost::lexical_cast<std::string>(rodI->rod));

      for(int i=0; i<12; i++) {
	std::string isName(isRodName + ".ADC" + boost::lexical_cast<std::string>(i));

	ISInfoDouble isValue(thisMonitor[i]);

	if(isDict.contains(isName.c_str())) {
	  isDict.update(isName.c_str(), isValue);
	} else {
	  isDict.insert(isName.c_str(), isValue);
	}
      }
    }

    sleep(60);
  }
}
