#include <map>

#include <boost/shared_ptr.hpp>

#include <ipc/object.h>
#include <is/isinfo.h>
#include <mrs/message.h>

namespace SctApi {
  class SctApi;
  class Trigger;
  class TriggerImpl;
  class Scan;
  class ScanDefImpl;
}

#include "Sct_SctApi.hh"

/**
   This gets defined in the main program,
   its needed to attach the Scans and Triggers
*/
extern std::auto_ptr<IPCServer> ipcServer; 

class ScanServer;
class TriggerServer;

/**
   The SctApi ILU implementation/wrapper
 */
class SctApiServer : public IPCObject, public virtual Sct_SctApi_T_SctApi {
 public:

  SctApiServer(SctApi::SctApi& api, const char* oid, IPCServer* server);
  virtual ~SctApiServer();		// destructor

 // methods

  virtual void initialiseAll (Sct_SctApiStatus *_status, ilu_Cardinal runNumber);
  virtual void shutdownAll (Sct_SctApiStatus *_status);
  virtual void status (Sct_SctApiStatus *_status);
  virtual void setRunNumber (Sct_SctApiStatus *_status, ilu_Cardinal newRun);
  virtual void setScanNumber (Sct_SctApiStatus *_status, ilu_Cardinal newScan);
  virtual ilu_Cardinal getRunNumber (Sct_SctApiStatus *_status);
  virtual ilu_Cardinal getScanNumber (Sct_SctApiStatus *_status);
  virtual void unsetDebugOption (Sct_SctApiStatus *_status, ilu_T_CString opt);
  virtual void setDebugOption (Sct_SctApiStatus *_status, ilu_T_CString opt);
  virtual Sct_SctApi_T_DefectList listEnabledDebugOptions (Sct_SctApiStatus *_status);
  virtual Sct_SctApi_T_DefectList listDebugOptions (Sct_SctApiStatus *_status);
  virtual void standardRegisterDump (Sct_SctApiStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal rod);
  virtual void standardRegisterDumpAll (Sct_SctApiStatus *_status);
  virtual sctConf_T_ModuleList getModuleList (Sct_SctApiStatus *_status);
  virtual ilu_Boolean isRODPresent (Sct_SctApiStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal rod);
  virtual void awaitResponse (Sct_SctApiStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal rod);
  virtual Sct_SctApi_T_DataBlock getResponse (Sct_SctApiStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal rod);
  virtual void configureBOC (Sct_SctApiStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal rod);
  virtual Sct_SctApi_T_BOCMonitorSequence getBOCMonitorArray (Sct_SctApiStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal rod);
  virtual void flashLED (Sct_SctApiStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal rod, ilu_ShortCardinal slaveNumber, ilu_Cardinal period, ilu_Cardinal flashes);
  virtual void echo (Sct_SctApiStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal rod, Sct_SctApi_T_DataBlock data);
  virtual void createDebugPrimList (Sct_SctApiStatus *_status);
  virtual void addDebugPrimList (Sct_SctApiStatus *_status, ilu_Integer index, ilu_Integer id, ilu_Integer version, Sct_SctApi_T_DataBlock body);
  virtual void sendDebugPrimList (Sct_SctApiStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal rod);
  virtual void sendDebugSlavePrimList (Sct_SctApiStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal rod, ilu_Cardinal slave, ilu_Boolean await, ilu_Boolean response);
  virtual void loadConfiguration (Sct_SctApiStatus *_status, ilu_T_CString filename);
  virtual void storeModuleConfigurations (Sct_SctApiStatus *_status);
  virtual void configureAllModules (Sct_SctApiStatus *_status);
  virtual sctConf_T_ABCDModule * retrieveModule (Sct_SctApiStatus *_status, ilu_Cardinal mid);
  virtual ilu_ShortInteger dspBlockDump (Sct_SctApiStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal rod, ilu_Integer dspStart, ilu_Integer numWords, ilu_Integer dspNumber);
  virtual Sct_SctApi_T_DataBlock dspBlockRead (Sct_SctApiStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal rod, ilu_Integer dspStart, ilu_Integer numWords, ilu_Integer dspNumber);
  virtual ilu_ShortInteger dspBlockWrite (Sct_SctApiStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal rod, Sct_SctApi_T_DataBlock buffer, ilu_Cardinal dspAddress, ilu_Integer dspNumber);
  virtual ilu_Cardinal dspSingleRead (Sct_SctApiStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal rod, ilu_Cardinal dspAddr, ilu_Integer dspNumber);
  virtual void dspSingleWrite (Sct_SctApiStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal rod, ilu_Cardinal dspAddr, ilu_Cardinal val, ilu_Integer dspNumber);
  virtual Sct_SctApi_T_DataBlock readSlaveDsp (Sct_SctApiStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal rod, ilu_ShortInteger s, ilu_Cardinal add, ilu_Cardinal words);
  virtual ilu_Cardinal findModuleSerial (Sct_SctApiStatus *_status, ilu_T_CString sn);
  virtual ilu_T_CString convertToString (Sct_SctApiStatus *_status, ilu_Cardinal mid);
  virtual ilu_Cardinal findModule (Sct_SctApiStatus *_status, ilu_ShortCardinal mur, ilu_ShortCardinal number);
  virtual ilu_Cardinal findModuleRod (Sct_SctApiStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal rod, ilu_Cardinal channel);
  virtual ilu_Cardinal findBarrelModule (Sct_SctApiStatus *_status, ilu_Cardinal barrel, ilu_Cardinal row, ilu_ShortInteger number);
  virtual void convertToBarrelModule (Sct_SctApiStatus *_status, ilu_Cardinal mid, ilu_Cardinal * barrel, ilu_Cardinal * row, ilu_ShortInteger * number);
  virtual ilu_Cardinal findEndcapModule (Sct_SctApiStatus *_status, ilu_Integer disk, ilu_Integer ring, ilu_Integer number);
  virtual void convertToEndcapModule (Sct_SctApiStatus *_status, ilu_Cardinal mid, ilu_Integer * disk, ilu_Cardinal * ring, ilu_Cardinal * number);
  virtual void getABCDModules (Sct_SctApiStatus *_status, Sct_SctApi_T_BankType bank);
  virtual void getABCDModule (Sct_SctApiStatus *_status, ilu_Cardinal mid, Sct_SctApi_T_BankType bank);
  virtual sctConf_T_ABCDModule * getABCDModuleRaw (Sct_SctApiStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal rod, ilu_Cardinal slot, Sct_SctApi_T_BankType bank);
  virtual void setABCDModule (Sct_SctApiStatus *_status, ilu_Cardinal mid, Sct_SctApi_T_BankType bank);
  virtual void setABCDModules (Sct_SctApiStatus *_status, Sct_SctApi_T_BankType bank);
  virtual void sendABCDModule (Sct_SctApiStatus *_status, ilu_Cardinal mid, Sct_SctApi_T_BankType bank, ilu_Cardinal type);
  virtual void sendABCDModules (Sct_SctApiStatus *_status, Sct_SctApi_T_BankType bank);
  virtual void modifyABCDMask (Sct_SctApiStatus *_status, ilu_Cardinal mid, Sct_SctApi_T_DataBlock mask);
  virtual void modifyABCDTrims (Sct_SctApiStatus *_status, ilu_Cardinal mid, Sct_SctApi_T_CharBlock trims);
  virtual void modifyABCDRC (Sct_SctApiStatus *_status, ilu_Cardinal mid, ilu_Cardinal chip, ilu_ShortCardinal index, ilu_Real p0, ilu_Real p1, ilu_Real p2);
  virtual void modifyABCDVar (Sct_SctApiStatus *_status, ilu_Cardinal typ, ilu_Real var);
  virtual void modifyABCDModuleVar (Sct_SctApiStatus *_status, ilu_Cardinal mid, ilu_Cardinal typ, ilu_Real var);
  virtual void modifyABCDChipVar (Sct_SctApiStatus *_status, ilu_Cardinal mid, ilu_Cardinal chip, ilu_Cardinal typ, ilu_Real var);
  virtual void modifyABCDVarROD (Sct_SctApiStatus *_status, ilu_Cardinal typ, ilu_Real var, Sct_SctApi_T_BankType bank);
  virtual void modifyABCDModuleVarROD (Sct_SctApiStatus *_status, ilu_Cardinal mid, ilu_Cardinal typ, ilu_Real var, Sct_SctApi_T_BankType bank);
  virtual void modifyBOCParam (Sct_SctApiStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal rod, ilu_Cardinal channel, ilu_Cardinal type, ilu_Cardinal val);
  virtual void lasersOff (Sct_SctApiStatus *_status);
  virtual void timSetFrequency (Sct_SctApiStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Real trigFreq, ilu_Real rstFreq);
  virtual void freeTriggers (Sct_SctApiStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate);
  virtual void stopTriggers (Sct_SctApiStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate);
  virtual void timL1A (Sct_SctApiStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate);
  virtual void timCalL1A (Sct_SctApiStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_ShortInteger delay);
  virtual ilu_ShortInteger timReadRegister (Sct_SctApiStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_ShortInteger value);
  virtual void timWriteRegister (Sct_SctApiStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_ShortInteger reg, ilu_ShortInteger value);
  virtual void sendTimTrigger (Sct_SctApiStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, class Sct_SctApi_T_Trigger * trig);
  virtual void sendTrigger (Sct_SctApiStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal rod, class Sct_SctApi_T_Trigger * trig);
  virtual void doScan (Sct_SctApiStatus *_status, class Sct_SctApi_T_Scan * thisScan);
  virtual void doRawScan (Sct_SctApiStatus *_status, class Sct_SctApi_T_Scan * thisScan, ilu_Integer delay, ilu_Integer width, ilu_Boolean configure, ilu_Boolean clockByTwo);
  virtual void printBOCSetup (Sct_SctApiStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal rod);
  virtual Sct_SctApi_T_BOCChannelList currentBOCSetup (Sct_SctApiStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal rod);
  virtual sctConf_T_BOCGlobalConfig * currentBOCRegisters (Sct_SctApiStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal rod);
  virtual void printABCDModule (Sct_SctApiStatus *_status, ilu_Cardinal mid);
  virtual void printABCDRodModule (Sct_SctApiStatus *_status, ilu_Cardinal mid, Sct_SctApi_T_BankType bank);
  virtual void decodeEvent (Sct_SctApiStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal rod, ilu_ShortInteger sl, ilu_ShortInteger index, ilu_Boolean extFlag, ilu_Boolean errorType);
  virtual void rawData (Sct_SctApiStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal rod, ilu_Integer delay, ilu_Integer units, ilu_Boolean setMask);
  virtual void rawDataWithTrigger (Sct_SctApiStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal rod, ilu_Integer delay, ilu_Integer units, ilu_Boolean setMask, class Sct_SctApi_T_Trigger * trig);
  virtual void sendL1A (Sct_SctApiStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal rod);
  virtual Sct_SctApi_T_CharBlock probe (Sct_SctApiStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal rod);
  virtual Sct_SctApi_T_CharBlock probeHarness (Sct_SctApiStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal rod, ilu_Cardinal harness);
  virtual Sct_SctApi_T_CharBlock probeWithTrigger (Sct_SctApiStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal rod, class Sct_SctApi_T_Trigger * trig);
  virtual Sct_SctApi_T_CharBlock probeHarnessWithTrigger (Sct_SctApiStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal rod, class Sct_SctApi_T_Trigger * trig, ilu_Cardinal harness);
  virtual Sct_SctApi_T_CharMatrix probeScanHarnessWithTrigger (Sct_SctApiStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal rod, class Sct_SctApi_T_Scan * trig, ilu_Cardinal harness);
  virtual ilu_Boolean checkAllModulesProbe (Sct_SctApiStatus *_status, ilu_T_CString chars);
  virtual Sct_SctApi_T_AutoResultList autoConfigureScan (Sct_SctApiStatus *_status);
  virtual ilu_Cardinal getRodSlot (Sct_SctApiStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal rod);
  virtual void testLinkOutSelect (Sct_SctApiStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal rod, ilu_Cardinal link);
  virtual ilu_Cardinal testLinkOutRetrieve (Sct_SctApiStatus *_status, ilu_Cardinal partition, ilu_Cardinal crate, ilu_Cardinal rod);
  virtual void requestHardReset (Sct_SctApiStatus *_status, ilu_Cardinal mid);
  virtual void requestIVCurve (Sct_SctApiStatus *_status, ilu_Cardinal mid, ilu_ShortReal start, ilu_ShortReal stop, ilu_ShortReal step, ilu_ShortCardinal delay, ilu_ShortReal currentLim);
  virtual void setSelect (Sct_SctApiStatus *_status, ilu_Cardinal mid, ilu_Boolean value);
  virtual void setSelectAllInCrate (Sct_SctApiStatus *_status, ilu_Integer crate, ilu_Boolean value);
  virtual void changeRunState (Sct_SctApiStatus *_status, ilu_Integer state);
  virtual void ddcSetSingleTimeout (Sct_SctApiStatus *_status, ilu_ShortInteger timeout);
  virtual ilu_ShortInteger ddcGetSingleTimeout (Sct_SctApiStatus *_status);
  virtual void ddcSetMultipleTimeout (Sct_SctApiStatus *_status, ilu_ShortInteger timeout);
  virtual ilu_ShortInteger ddcGetMultipleTimeout (Sct_SctApiStatus *_status);
  virtual void ddcChangeState (Sct_SctApiStatus *_status, ilu_Integer crate, ilu_Integer channel, ilu_ShortInteger state);
  virtual void ddcChangeStateAll (Sct_SctApiStatus *_status, ilu_Integer crate, ilu_ShortInteger state);
  virtual void ddcLoadConfiguration (Sct_SctApiStatus *_status, ilu_Integer crate, ilu_ShortInteger state);
  virtual void ddcHardReset (Sct_SctApiStatus *_status, ilu_Integer crate, ilu_Integer channel);
  virtual void ddcHardResetAll (Sct_SctApiStatus *_status, ilu_Integer crate);
  virtual ilu_Cardinal ddcGetChannelParameterInt (Sct_SctApiStatus *_status, ilu_Integer crate, ilu_Integer channel, ilu_T_CString name);
  virtual ilu_ShortReal ddcGetChannelParameterFloat (Sct_SctApiStatus *_status, ilu_Integer crate, ilu_Integer channel, ilu_T_CString name);
  virtual ilu_T_CString ddcGetChannelParameterString (Sct_SctApiStatus *_status, ilu_Integer crate, ilu_Integer channel, ilu_T_CString name);
  virtual ilu_Cardinal ddcGetCardParameterInt (Sct_SctApiStatus *_status, ilu_Integer crate, ilu_Integer card, ilu_T_CString name);
  virtual ilu_ShortReal ddcGetCardParameterFloat (Sct_SctApiStatus *_status, ilu_Integer crate, ilu_Integer card, ilu_T_CString name);
  virtual ilu_T_CString ddcGetCardParameterString (Sct_SctApiStatus *_status, ilu_Integer crate, ilu_Integer card, ilu_T_CString name);
  virtual ilu_Cardinal ddcGetCrateParameterInt (Sct_SctApiStatus *_status, ilu_Integer crate, ilu_T_CString name);
  virtual ilu_ShortReal ddcGetCrateParameterFloat (Sct_SctApiStatus *_status, ilu_Integer crate, ilu_T_CString name);
  virtual ilu_T_CString ddcGetCrateParameterString (Sct_SctApiStatus *_status, ilu_Integer crate, ilu_T_CString name);
  virtual void ddcGetCrateParameters (Sct_SctApiStatus *_status, ilu_Integer crate, Sct_SctApi_T_NameList names, Sct_SctApi_T_NameValueList nameValues);
  virtual class Sct_SctApi_T_Scan * createScan (Sct_SctApiStatus *_status);
  virtual class Sct_SctApi_T_Scan * getDefaultScan (Sct_SctApiStatus *_status);
  virtual class Sct_SctApi_T_Trigger * createTrigger (Sct_SctApiStatus *_status);
  virtual class Sct_SctApi_T_Trigger * getDefaultTrigger (Sct_SctApiStatus *_status);
  virtual Sct_SctApi_T_ScanList knownScans (Sct_SctApiStatus *_status);

  std::list<Sct_SctApi_T_Scan *> scans;

  ScanServer *defaultScan;
  TriggerServer *defaultTrigger;

  static SctApiServer *singleton;

 protected:
  SctApi::SctApi &worker();

  MRSStream mrsStream;
  ISInfoDictionary isDict;
  
  ilu_ShortInteger ddcSingleTimeout;
  ilu_ShortInteger ddcMultipleTimeout;

 private:
  SctApi::SctApi& api;
};

// ILU wrapper for SctApi::Scan class
class ScanServer : public IPCObject, public virtual Sct_SctApi_T_Scan {
  ScanServer(const ScanServer &);
  ScanServer &operator=(const ScanServer &);

  static int nextNumber;

 public:
  ScanServer(IPCServer* server);

  ScanServer(IPCServer* server, const ScanServer &copy);

  virtual ~ScanServer();

  virtual void print (Sct_SctApiStatus *_status);
  virtual void configure (Sct_SctApiStatus *_status, ilu_ShortCardinal type, ilu_Real start, ilu_Real stop, ilu_Real step);
  virtual void configure2 (Sct_SctApiStatus *_status, ilu_ShortCardinal type, ilu_Real start, ilu_Real stop, ilu_Real step);
  virtual class Sct_SctApi_T_Trigger * getTrigger1 (Sct_SctApiStatus *_status);
  virtual class Sct_SctApi_T_Trigger * getTrigger2 (Sct_SctApiStatus *_status);
  virtual void setTrigger1 (Sct_SctApiStatus *_status, class Sct_SctApi_T_Trigger * trig);
  virtual void setTrigger2 (Sct_SctApiStatus *_status, class Sct_SctApi_T_Trigger * trig);
  virtual void setScanVariable1 (Sct_SctApiStatus *_status, ilu_ShortCardinal var);
  virtual void setScanVariable2 (Sct_SctApiStatus *_status, ilu_ShortCardinal var);
  virtual ilu_ShortCardinal getScanVariable1 (Sct_SctApiStatus *_status);
  virtual ilu_ShortCardinal getScanVariable2 (Sct_SctApiStatus *_status);
  virtual void setNTrigs (Sct_SctApiStatus *_status, ilu_Cardinal nTrigs);
  virtual ilu_Cardinal getNTrigs (Sct_SctApiStatus *_status);
  virtual Sct_SctApi_T_TrigPoints getVariableTrigs (Sct_SctApiStatus *_status);
  virtual void setVariableTrigs (Sct_SctApiStatus *_status, Sct_SctApi_T_TrigPoints trigs);
  virtual void setVariableTrigRange (Sct_SctApiStatus *_status, ilu_ShortCardinal start, ilu_ShortCardinal end, ilu_Cardinal value);
  virtual Sct_SctApi_T_ScanPoints getScanPoints1 (Sct_SctApiStatus *_status);
  virtual Sct_SctApi_T_ScanPoints getScanPoints2 (Sct_SctApiStatus *_status);
  virtual void setScanPoints1 (Sct_SctApiStatus *_status, Sct_SctApi_T_ScanPoints scans);
  virtual void setScanPoints2 (Sct_SctApiStatus *_status, Sct_SctApi_T_ScanPoints scans);
  virtual ilu_Integer getOption (Sct_SctApiStatus *_status, Sct_SctApi_T_Scan_ScanOptions opt);
  virtual void setOption (Sct_SctApiStatus *_status, Sct_SctApi_T_Scan_ScanOptions opt, ilu_Integer val);
  virtual ilu_Cardinal getScanNumber (Sct_SctApiStatus *_status);
  virtual ilu_Cardinal getRunNumber (Sct_SctApiStatus *_status);
  virtual sctConf_T_ModuleList getModuleList (Sct_SctApiStatus *_status, ilu_Cardinal group);
  virtual ilu_Cardinal getNGroups (Sct_SctApiStatus *_status);
  virtual ilu_T_CString getStartTime(Sct_SctApiStatus *_status);
  virtual ilu_T_CString getEndTime(Sct_SctApiStatus *_status);

  // Override default freeable
  virtual void destroy(ipcStatus *_status);

  boost::shared_ptr<SctApi::Scan> m_worker;

 protected:
  static std::string getServerName();

 protected:
  SctApi::Scan &worker();
};

// ILU wrapper for SctApi::Trigger class
class TriggerServer : public IPCObject, public virtual Sct_SctApi_T_Trigger {
  TriggerServer(const TriggerServer &);
  TriggerServer &operator=(const TriggerServer &);

  static int nextNumber;

 public:
  TriggerServer(/*const char *oid, */IPCServer* server);

  static TriggerServer *getServer(boost::shared_ptr< ::SctApi::Trigger> trigger);
  static void mapServer(boost::shared_ptr< ::SctApi::Trigger> trigger, TriggerServer *server);

  virtual ~TriggerServer();

  virtual void print (Sct_SctApiStatus *_status);
  virtual void singleL1A (Sct_SctApiStatus *_status);
  virtual void doubleL1A (Sct_SctApiStatus *_status, ilu_ShortCardinal delay);
  virtual void delayedL1A (Sct_SctApiStatus *_status, ilu_ShortCardinal delay);
  virtual void calL1A (Sct_SctApiStatus *_status, ilu_ShortCardinal delay);
  virtual void pulseL1A (Sct_SctApiStatus *_status, ilu_ShortCardinal delay);
  virtual void softL1A (Sct_SctApiStatus *_status, ilu_ShortCardinal delay);
  virtual void softCalL1A (Sct_SctApiStatus *_status, ilu_ShortCardinal delay, ilu_ShortCardinal delay2);
  virtual void softPulseL1A (Sct_SctApiStatus *_status, ilu_ShortCardinal delay, ilu_ShortCardinal delay2);
  virtual void bcL1A (Sct_SctApiStatus *_status, ilu_ShortCardinal delay);
  virtual void bcCalL1A (Sct_SctApiStatus *_status, ilu_ShortCardinal delay, ilu_ShortCardinal delay2);
  virtual void bcPulseL1A (Sct_SctApiStatus *_status, ilu_ShortCardinal delay, ilu_ShortCardinal delay2);
  virtual void setCommIncr (Sct_SctApiStatus *_status, ilu_ShortCardinal command, ilu_ShortCardinal incr);
  virtual void getCommIncr (Sct_SctApiStatus *_status, ilu_ShortCardinal * command, ilu_ShortCardinal * incr);

  virtual void destroy(ipcStatus *_status);

  boost::shared_ptr<SctApi::TriggerImpl> m_worker;

 protected:
  static std::map<boost::shared_ptr< ::SctApi::Trigger>, TriggerServer *> serverMap;

  static std::string getServerName();

  SctApi::Trigger &worker();
};

