#include <iostream>
#include <ipc/object.h>

#include "Sct_SctApi.hh"

int main(int argv, char** argc) {
  Sct_SctApiStatus status;	
  IPCPartition p("SCT");
  IPCObjectVar<Sct_SctApi_T_SctApi> handle = 
    p.lookup("Test_Server", "SCTSctApiServer", Sct_SctApi_T_SctApi::ILUClassRecord);
  if (handle ==0 ) {
    std::cout << "Error getting SctApi" << std::endl;
    return -1;
  }
  status.returnCode = 0;

  std::cout << "Successfully got the Api server reference?\n";

  handle->status(&status);

  std::cout << "Get default Scan\n";

  IPCObjectVar<Sct_SctApi_T_Scan> scanHandle = 
    handle->createScan(&status);

  if (scanHandle == 0) {
    std::cout << "Error getting scan\n";
  } else {
    std::cout << "Try printing scan\n";
    scanHandle->print(&status);

  }

  std::cout << "Try getting default trigger directly\n";

  IPCObjectVar<Sct_SctApi_T_Trigger> triggerHandle = 
    handle->createTrigger(&status);

  if (triggerHandle == 0) {
    std::cout << "Error getting Trigger\n";
  } else {
    std::cout << "Try printing trigger\n";
    triggerHandle->print(&status);
//     cout << "Go to sleep a bit\n";
//     sleep(5);
//     cout << "Wake up and kill server\n";
  }

  if(scanHandle) {
    std::cout << "Try getting trigger from scan\n";
    IPCObjectVar<Sct_SctApi_T_Trigger> scanTrigger = scanHandle->getTrigger1(&status);

    if (scanTrigger == 0) {
      std::cout << "Error getting Trigger\n";
    } else {
      std::cout << "Try printing trigger\n";
      scanTrigger->print(&status);

      std::cout << "Changing trigger\n";
      scanTrigger->softCalL1A(&status, 100, 200);

      std::cout << "Print trigger again\n";
      scanTrigger->print(&status);

      std::cout << "Print scan\n";
      scanHandle->print(&status);
    }

    std::cout << "Try getting another trigger from scan\n";
    scanTrigger = scanHandle->getTrigger2(&status);

    if (scanTrigger == 0) {
      std::cout << "Error getting Trigger2\n";
    } else {
      std::cout << "Try printing trigger2\n";
      scanTrigger->print(&status);
    }
  }

  handle->doScan(&status, scanHandle);


  std::cout << "Destroy server\n";

  ipcStatus status2;
  handle->destroy(&status2);
}
