#include <iostream>
#include <string>

#include "primUtils.h"

#include "utility.h"

#include "registerIndices.h"

#include "ABCD/ABCDscans.h"
#include "ABCD/ABCDchip.h"

#include "CommonWithDsp/primParams.h"

#ifdef HAVE_PRIM_NAMES

#include "../decodeTestStand/primNames.h"
#include "../decodeTestStand/regNames.h"
static const char *getPrimName(int id);
static const char *getRegName(int id);
static const char *getTaskName(int id);

#endif

using namespace std;
using namespace SctApi::Utility;

namespace SctApi {

void printOutList(unsigned long *result, unsigned long length, bool in, int level, ostream &stream, 
                  bool dumpUnknown, bool dumpRaw) {
  if(!result) {
    cout << "Invalid pointer to primList\n";
    return;
  }
  if(length < 10) { 
    cout << "Invalid prim list (too short)\n";
    return;
  }
  unsigned long outLength = result[0];
  unsigned long outIndex = result[1];
  unsigned long outNumPrims = result[2];
  unsigned long outPrimVersion = result[3];

  if(!in) {
    stream << string("        ", 0, level);
    stream << "Outlist decode: \n";
    stream << string("        ", 0, level);
    stream << "outLength = " << outLength << ", outIndex = " << outIndex << 
      ", outNumPrims = " << outNumPrims << ", outPrimVersion = " << 
      outPrimVersion <<'\n';
  } else {
    stream << string("        ", 0, level);
    stream << "Inlist decode: \n";
    stream << string("        ", 0, level);
    stream << "inLength = " << outLength << ", inIndex = " << outIndex << 
      ", inNumPrims = " << outNumPrims << ", inPrimVersion = " << 
      outPrimVersion <<'\n';
  }
  unsigned long *outPtr = result + 4;
  for (unsigned int j=0; j<outNumPrims; j++) {
    unsigned long primLength = *(outPtr++);
    unsigned long primIndex = *outPtr++;
    unsigned long primId = *outPtr++;
    unsigned long primVersion = *outPtr++;
    stream << string("        ", 0, level);
    stream << "primLength = " << primLength << ", primIndex = " << primIndex << 
      ", primId = " << primId << ", primVersion = " << primVersion;
#ifdef HAVE_PRIM_NAMES
    stream << " " << getPrimName(primId);
#endif
    stream << '\n';
    if(in) { // Input list
      if(primId == SEND_SLAVE_LIST) {
        stream << string("        ", 0, level);
        stream << " Send list to slave DSP " << outPtr[0] << " length " << outPtr[1] << ":\n";
        printOutList(outPtr + 4, outPtr[1], in, level+2, stream, dumpUnknown, dumpRaw);
      } else if(primId == START_SLAVE_LIST) {
        stream << string("        ", 0, level);
        stream << " Start slave list on " << outPtr[0] << endl;
      } else if(primId == START_TASK) {
        START_TASK_IN &prim =  *(START_TASK_IN *)outPtr;

        stream << string("        ", 0, level);
        int taskId = prim.taskType;

#ifdef HAVE_PRIM_NAMES
        stream << "Start task " << getTaskName(taskId) << " (" << taskId << ")" << endl;
#else
        stream << "Start task " << " (" << taskId << ")" << endl;
#endif
        unsigned long *taskPtr = outPtr + 4;

        int tLevel = level + 1;

#if (R_HISTOGRAM_CTRL_TASK == 107)
        if(taskId == HISTOGRAM_CTRL_TASK) {
          HISTOGRAM_CTRL_TASK_IN &task = *(HISTOGRAM_CTRL_TASK_IN*)taskPtr;
          stream << "Histogramming\n";
          stream << string("        ", 0, tLevel);
          stream << "SlaveBits 0x" << hex << (int)task.slvBits << dec << " Port " << (int)task.port 
                 << " cfgRegs " << (int)task.configRegister[0] << " " << (int)task.configRegister[1] << endl;
          stream << string("        ", 0, tLevel);
          stream << "ConfigSet " << (int)task.configSctSet << " DataSet " << (int)task.dataSet 
                 << " GroupRangeMaps 0x" << hex << (int)task.groupRangeMap[0] 
                 << " 0x" << (int)task.groupRangeMap[1] << dec << endl;
          stream << string("        ", 0, tLevel);
          stream << " GroupDspMaps 0x" << hex << (int)task.groupDSPMap[0] << " 0x" << (int)task.groupDSPMap[1] 
                 << " 0x" << (int)task.groupDSPMap[2] << " 0x" << (int)task.groupDSPMap[3] << dec;
          stream << " Group SP Maps 0x" << hex << (int)task.groupSPMap[0] 
                 << " 0x" << (int)task.groupSPMap[1] << dec << endl;
          stream << string("        ", 0, tLevel);
          stream << "Histogram address " << hex << task.histoBase << dec << endl;  // pointer
          stream << string("        ", 0, tLevel);
          stream << "do occupancy " << (int)task.doChipOcc << " dataFormat " << (int)task.dataFormat 
                 << " Binsize " << (int)task.binSize << " extSetup " << (int)task.extSetup 
                 << " dataPath " << (int)task.dataPath << " capture " << (int)task.capture 
                 << " useRangeList " << (int)task.useRangeList << endl;
          stream << string("        ", 0, tLevel);
          stream << "Reps " << task.repetitions << " NBins " << task.nBins << " Bin0 " << task.bin0 << endl;
          stream << string("        ", 0, tLevel);
          stream << "Data pointers " << task.dataPtr[0] << " " << task.dataPtr[1] << endl;
          for(int t=0; t<2; t++) {
            stream << "Trigger " << t << endl;
            for(int i=0; i<N_CMD_LIST_CMDS; i++) {
              stream << task.triggerSequence[t].cmd[i] << ": " << task.triggerSequence[t].data[i] << "  ";
            }
            stream << endl;
          }
          stream << string("        ", 0, tLevel);
          stream << "incCmds " << (int)task.incCmd[0] << " " << (int)task.incCmd[1] 
                 << " calLineLoop " << (int)task.calLineLoop << " DistToggle " << (int)task.distributionToggle 
                 << " incData " << (int)task.incData[0] << " " << (int)task.incData[1] 
                 << endl;
          stream << string("        ", 0, tLevel);
          stream << "Gendata: ";
          hex(stream);
          for(int i=0; i<10; i++) stream << " 0x" << task.genData[i];
          dec(stream);
          stream << endl;
          FLOAT32 *dataPtr = (FLOAT32*)(outPtr + sizeof(START_TASK_IN)/4); // HISTOGRAM_SETUP_IN));
          stream << string("        ", 0, tLevel+2);
          int count = primLength - (sizeof(START_TASK_IN)/4) - 4;
          for(unsigned int b=0; b<count; b++) {
            if(b == count/2) {
              stream << endl;
              stream << string("        ", 0, tLevel+2);
            }
            stream << dataPtr[b] << " ";
          }
          stream << endl;
        } else 
#else
#warning "Debug output for HISTOGRAM_CTRL_TASK not compiled!"
#endif
        if(taskId == HISTOGRAM_TASK) {
          HISTOGRAM_TASK_IN &task = *(HISTOGRAM_TASK_IN*)taskPtr;
          stream << string("        ", 0, tLevel);
          stream << "NEvents " << task.nEvents << " controlFlag = " << task.controlFlag << endl;
        } else { // Unknown task
          if(dumpUnknown) 
            printMemoryBlock(stream, outPtr+4, primLength-8, 8, level+1);
        }
      } else if(primId == RW_SLAVE_MEMORY) {
        stream << string("        ", 0, level+1);
        stream << (outPtr[1]?"READ":"WRITE") << " 0x" << hex << outPtr[4] << dec << " words " << (outPtr[1]?"from":"to") << " slave " << outPtr[0] << " address 0x" << hex << outPtr[2] << dec << endl;
        if(dumpRaw)
          printMemoryBlock(stream, outPtr+5, primLength-9, 8, level+1);
      } else if(primId == RW_REG_FIELD) {
        RW_REG_FIELD_IN &prim =  *(RW_REG_FIELD_IN *)outPtr;
        stream << string("        ", 0, level+1);
        stream << (prim.readNotWrite?"READ":"WRITE") 
               << " register 0x" << hex << prim.registerID << dec
#if HAVE_PRIM_NAMES
               << " (" << getRegName(prim.registerID) << ") "
#endif
               << " offset " << prim.offset 
               << " width " << prim.width;
        if(!prim.readNotWrite) {
          stream << " data 0x" << hex << prim.dataIn << dec;
        }
        stream << endl;
#if R_EVENT_TRAP_SETUP == 103
      } else if(primId == EVENT_TRAP_SETUP) {
        stream << string("        ", 0, level);
        stream << " Slaves " << outPtr[0] << " Events " << outPtr[1] << " Timeout: " << outPtr[2] << endl;

        stream << string("        ", 0, level);
        stream << " Ext: " << outPtr[3] << " Dist: " << outPtr[4] << " Release: " << outPtr[5] << " Back: " << outPtr[6] << endl;
        stream << string("        ", 0, level);
        stream << " Mode: " << outPtr[7] << " sLink: " << outPtr[8] << " Format: " << outPtr[9] << " Strays: " << outPtr[10] << " IterLimit: " << outPtr[11] << endl;
        stream << string("        ", 0, level);
        stream << " 0: Config: " << outPtr[12] << " Xclude: " << outPtr[14] << " Function: " << outPtr[16];
        stream << " Match: " << outPtr[18] << " Modulus: " << outPtr[20] << " Remainder: " << outPtr[22] << endl;
        stream << string("        ", 0, level);
        stream << " 1: Config: " << outPtr[13] << " Xclude: " << outPtr[15] << " Function: " << outPtr[17];
        stream << " Match: " << outPtr[19] << " Modulus: " << outPtr[21] << " Remainder: " << outPtr[23] << endl;
#else
#warning "Debug output for EVENT_TRAP_SETUP not compiled!"
#endif
#if (R_HISTOGRAM_SETUP == 108)
      } else if(primId == HISTOGRAM_SETUP) {
        HISTOGRAM_SETUP_IN &prim =  *(HISTOGRAM_SETUP_IN *)outPtr;
        stream << string("        ", 0, level);
        stream << " HistoBase = " << hex << prim.base << dec << " nBins: " << prim.nBins << endl;  // pointer

        stream << string("        ", 0, level);
        stream << " DataTypes: " << (int)prim.dataType[0] << " " << (int)prim.dataType[1] << endl;
        stream << string("        ", 0, level);
        stream << " (Arrangement: " << (int)prim.opt[0] << ") DataFormat: " << (int)prim.opt[1] 
               << " BinSize: " << prim.binSize << " Routine type: " << prim.routineType
               << " (Ignored: " << (int)prim.opt[2] << ")" << endl;

        stream << string("        ", 0, level);
        stream << " Module Maps: 0x" << hex << prim.validModules[0] << " 0x" << prim.validModules[1] << dec
               << " RangeMaps: 0x" << hex << prim.moduleRangeMap[0][0] << " 0x" << prim.moduleRangeMap[0][1] 
               << " 0x" << prim.moduleRangeMap[1][0] << " 0x" << prim.moduleRangeMap[1][1] << dec << endl;
        stream << string("        ", 0, level);
        stream << " Data Pointers " << hex << prim.xPtr[0] << " " << prim.xPtr[1] << dec << "\n";   // pointers
#elif (R_HISTOGRAM_SETUP == 105 || R_HISTOGRAM_SETUP == 107)
      } else if(primId == HISTOGRAM_SETUP) {
        HISTOGRAM_SETUP_IN &prim =  *(HISTOGRAM_SETUP_IN *)outPtr;
        stream << string("        ", 0, level);
        stream << " HistoBase = " << hex << prim.base << dec << " nBins: " << prim.nBins << endl;  // pointer

//         unsigned char *charPtr = (unsigned char *)prim.padding[3];
        stream << string("        ", 0, level);
        stream << " Padding: " << (int)prim.padding[0] << " " << (int)prim.padding[1] 
               << " DataTypes: " << (int)prim.dataType[0] << " " << (int)prim.dataType[1] << endl;
        stream << string("        ", 0, level);
        stream << " Arrangement: " << (int)prim.opt[0] << " DataFormat: " << (int)prim.opt[1] 
               << " BinSize: " << (int)prim.binSize << " (Ignored: " << (int)prim.opt[2] << ")" << endl;

        stream << string("        ", 0, level);
        stream << " Module Maps: 0x" << hex << prim.validModules[0] << " 0x" << prim.validModules[1] << dec
               << " RangeMaps: 0x" << hex << prim.moduleRangeMap[0][0] << " 0x" << prim.moduleRangeMap[0][1] 
               << " 0x" << prim.moduleRangeMap[1][0] << " 0x" << prim.moduleRangeMap[1][1] << dec << endl;
        stream << string("        ", 0, level);
        stream << " Data Pointers " << hex << prim.xPtr[0] << " " << prim.xPtr[1] << dec << "\n";   // pointers
#elif R_HISTOGRAM_SETUP == 104
      } else if(primId == HISTOGRAM_SETUP) {
        HISTOGRAM_SETUP_IN &prim =  *(HISTOGRAM_SETUP_IN *)outPtr;
        stream << string("        ", 0, level);
        stream << " HistoBase = 0x" << hex << outPtr[0] << dec << " RodType " << outPtr[1] << " nBins: " << outPtr[2] << endl;

        unsigned char *charPtr = (unsigned char *)&outPtr[3];
        stream << string("        ", 0, level);
        stream << " Padding: " << (int)charPtr[0] << " " << (int)charPtr[1] << " DataTypes: " << (int)charPtr[2] << " " << (int)charPtr[3] << endl;
        stream << string("        ", 0, level);
        stream << " Arrangement: " << (int)charPtr[4] << " DataFormat: " << (int)charPtr[5] << " BinSize: " << (int)charPtr[6] << endl;

        stream << string("        ", 0, level);
        stream << " Module Maps: 0x" << hex << outPtr[5] << " 0x" << outPtr[6] << dec
               << " RangeMaps: 0x" << hex << outPtr[7] << " 0x" << outPtr[8] 
               << " 0x" << outPtr[9] << " 0x" << outPtr[10] << dec << endl;
        stream << string("        ", 0, level);
        stream << " Data Pointers " << hex << prim.xPtr[0] << " " << prim.xPtr[1] << dec << "\n";  // pointers
#else
#warning "Debug output for HISTOGRAM_SETUP not compiled!"
#endif
      } else if(primId == WRITE_BUFFER) {
        stream << string("        ", 0, level + 1) << " Length " << outPtr[0] << endl;
        stream << string("        ", 0, level + 1) << " \"" << string((char *)&outPtr[1], 0, outPtr[0]) << "\"" << endl;
      } else if(primId == MODULE_MASK) {
        MODULE_MASK_IN &prim = *(MODULE_MASK_IN*)outPtr;
        stream << string("        ", 0, level + 1) << " Module " << prim.moduleNum 
               << " port " << prim.port << " structSet " << prim.useStructSet << " pass to slaves " << prim.passOn 
               << "  slvMask 0x" << hex << prim.slvBits << dec << endl;
        stream << string("        ", 0, level + 1) 
               << " cmdLine " << prim.cmdLine << " dataLine [0] " << prim.dataLine[0] << "  [1] " << prim.dataLine[1] 
               << "  [2] " << prim.dataLine[2] << "  [3] " << prim.dataLine[3] << endl;
        stream << string("        ", 0, level + 1) << " cfg " << prim.cfg 
               << " modMask 0x" << hex << prim.modMask[0] << " 0x" << prim.modMask[1] << dec 
               << " maskType " << prim.maskType << " storage " << prim.storage 
               << " maskSet " << prim.maskSet << endl ;
      } else if(primId == RW_MODULE_DATA) {
        stream << string("        ", 0, level + 1) << (outPtr[0]?"Read":"Write") 
               << " Struct: " << outPtr[1] << " Module: " << outPtr[2] << endl;
        stream << string("        ", 0, level + 1) << "Skip module data\n";
      } else if(primId == SET_ROD_MODE) {
        SET_ROD_MODE_IN &prim = *(SET_ROD_MODE_IN*)outPtr;
        stream << string("        ", 0, level + 1) << " mode 0x" << hex << prim.mode << dec << " flag " << prim.flag 
               << " fifo " << prim.fifoSetup << " nBits " << prim.nBits << " delay " << prim.delay 
               << " evtsPerL1A " << prim.evtsPerL1A << " message " << prim.message << endl;
      } else if(primId == RW_MODULE_VARIABLE) {
        RW_MODULE_VARIABLE_IN &prim = *(RW_MODULE_VARIABLE_IN*)outPtr;
        stream << string("        ", 0, level + 1) << " " << (prim.read?"READ":"WRITE") << " struct " << prim.structId 
               << " group " << prim.groupId << " module " << prim.module << " chip " << prim.chip 
               << " var " << prim.varType << endl;
      } else if(primId == SET_MEMORY) {
        SET_MEMORY_IN &prim = *(SET_MEMORY_IN*)outPtr;
        stream << string("        ", 0, level + 1) << " address" << prim.start << " length " << prim.size 
               << " value " << prim.val << endl;
      } else if(primId == SEND_CONFIG) {
        SEND_CONFIG_IN &prim = *(SEND_CONFIG_IN*)outPtr;
        stream << string("        ", 0, level + 1) << " port " << prim.port << " capture " << prim.captureSerOn 
               << " moduleNum (" << prim.moduleNum[0] << " " << prim.moduleNum[1] << ")" 
               << " chipNum 0x" << hex << prim.chipNum << dec << " setLinks " << prim.setLinks << endl;
        stream << string("        ", 0, level + 1) << " restore " << prim.restore << " struct " << prim.structId 
               << " dataType " << prim.dataType << " activeOnly " << prim.activeOnly 
               << " enableDataTaking " << prim.enableDataTaking << endl;
      } else if(primId == TASK_OPERATION) {
        TASK_OPERATION_IN &prim = *(TASK_OPERATION_IN*)outPtr;
        stream << string("        ", 0, level + 1) 
               << " task " 
#ifdef HAVE_PRIM_NAMES
               << getTaskName(prim.taskType) << " (" << prim.taskType << ")";
#else
               << prim.taskType;
#endif
        switch(prim.taskOperation) {
        case TASK_STOP:         stream << " STOP"; break;
        case TASK_PAUSE:        stream << " PAUSE"; break;
        case TASK_RESUME:       stream << " RESUME"; break;
        case TASK_QUERY:        stream << " QUERY"; break;
        case TASK_RESET:        stream << " RESET"; break;
        case TASK_SETPRIORITY:  stream << " SETPRIORITY"; break;
        }
        stream  << " data " << prim.data << endl;
      } else { // Unknown primitive
        if(dumpUnknown)
          printMemoryBlock(stream, outPtr, primLength-4, 8, level+1);
      }
    } else { // Out list
      if(primId == ECHO) {
        stream << string("        ", 0, level);
        stream << "ECHO Primitive response:\n";
        hex(stream);
        for (unsigned int i=0; i<primLength-4; i++) {
          stream.width(8);
          stream << outPtr[i] <<" ";
          if (0 == (i+1)%8) {
            stream << endl; 
            stream << string("        ", 0, level);
          }
        }
        if (0 != (primLength-4)%8) stream << endl;
        dec(stream);
      } else if(primId == SEND_SLAVE_LIST) {
        stream << string("        ", 0, level);
        stream << "Response to slave DSP list:\n";
        printOutList(outPtr, outPtr[-4]-6, in, level+1, stream, dumpUnknown, dumpRaw);
      } else if(primId == SEND_DATA) {
        stream << string("        ", 0, level);
        stream << "Response to SEND_DATA:\n";
        SEND_DATA_OUT &dataOut = *(SEND_DATA_OUT *)outPtr;
        stream << string("        ", 0, level + 1);
        stream << "pointer: " << dataOut.dataPtr << " length: 0x" << hex << dataOut.dataLength << dec << endl;
      } else if(primId == RW_SLAVE_MEMORY) {
        stream << string("        ", 0, level+1);
        stream << "Response to read slave memory\n";
        if(dumpRaw)
          printMemoryBlock(stream, outPtr, primLength-4, 8, level+1);
      } else { // Unknown primitive
        if(dumpUnknown)
          printMemoryBlock(stream, outPtr, primLength-4, 8, level+1);
      }
    }

    outPtr += primLength-4;
  }
  unsigned long trailLength = *outPtr++;
  unsigned long trailCheck = *outPtr++;
  stream << string("        ", 0, level);
  if(in) 
    stream << "Inlist ";
  else 
    stream << "Outlist ";
  stream << "Trailer: length = " << trailLength  << " check = 0x" << hex << trailCheck << dec << endl;
  stream << string("        ", 0, level);
  stream << "End of response\n";
}

}

#ifdef HAVE_PRIM_NAMES

const char *getPrimName(int id) {
  for(int i=0; primNames[i].id != -1; i++) {
    if(primNames[i].id == id) {
      return primNames[i].name;
    }
  }

  return "unknown";
}

const char *getRegName(int id) {
  for(int i=0; regNames[i].id != -1; i++) {
    if(regNames[i].id == id) {
      return regNames[i].name;
    }
  }

  return "unknown";
}

const char *getTaskName(int id) {
  for(int i=0; taskNames[i].id != -1; i++) {
    if(taskNames[i].id == id) {
      return taskNames[i].name;
    }
  }

  return "unknown";
}

#endif
