{
// Manually set up for a TIM histogram...

// setNmask requires Functs.cxx to have been loaded
setNmask(120);

tapi.createDebugPrimList();
tapi.debugPrimListFromFile("synchETS2.bin");
// tapi.debugPrimListFromFile("synchETSSingle.bin");
tapi.sendDebugPrimList(0, 0, 0);
tapi.awaitResponse(0, 0, 0);

gSystem->Sleep(100);

// Set TIM trigger frequency to 6kHz
tapi.timRegLoad(0, 0, 6, 9);

// Set TIM BC offset to 3
tapi.timRegLoad(0, 0, 0x14, 0x3000);
//tapi.timRegLoad(0, 0, 0x14, 0x0000);

// 0x1c2 bit 5   Trap all events...?

tapi.rodMode(0, 0, 0, 0x20000, 0, 1, 0, 0, 1); 

// Use ROD mode bits 
// tapi.dspSingleWrite(0, 0, 0, 0x80000010, 1<<2, -1);
// tapi.setABCDModules(0);

// FE command input source to TIM
// writeRegister(0x217, 1, 1, 1);
// Decode TIM event IDs
// writeRegister(0x217, 8, 1, 1);

// writeRegister(0x202, 3, 1, 1);   // Inhibit S-link write
writeRegister(0x202, 7, 1, 1);   // Mask LDown#

// DM_DFLT_LUT(0-7)
// for(int f=0; f<8; f++) writeRegister(0x270 + f, 0, 16, 0xaaaa);

// Mask L1
// ERROR_MASK(0-1, 0-47)  bit 5
// for(int e=0; e<2; e++) for(int f=0; f<48; f++) writeRegister(0x140+(0x30*e)+f, 5, 1, 1);

// Clear L1ID mask
//for(int e=0; e<2; e++) for(int f=0; f<48; f++) writeRegister(0x140+(0x30*e)+f, 5, 1, 0);

readRegister(0x202);  // Event types
readRegister(0x203);  // Event types
readRegister(0x1a6);  // EFB status 
readRegister(0x21c);  // RRIF status 0
readRegister(0x270);  // DM_DFLT_LUT 0
// readRegister(0x140);  // Dynamic mask in [14:15]

tapi.createDebugPrimList();
tapi.debugPrimListFromFile("synchHisto_108_1416.bin");
tapi.sendDebugPrimList(0, 0, 0);
tapi.awaitResponse(0, 0, 0);

// Don't put stuff into correct bins...
// for(int i=0; i<256; i++) {
//   unsigned int offset = 0x120 + i * 4;
//   tapi.dspSingleWrite(0, 0, 0, 0x10000 + offset, 0xa00e2000 + 0x1000 * i, 0);
// }

// Set up L1 and BCIDs?

// TTrigger soft; soft.softL1A(30); tapi.sendTrigger(0, 0, 0, soft);

// tapi.timL1A(0, 0);
tapi.timSoftReset(0, 0);
tapi.timBCReset(0, 0);

int bin = 0;
for(int i=0; i<4; i++) { setTrigger(bin, i); }

gSystem->Sleep(100);

// Send triggers
// tapi.sendTimBurst(0, 0, 1000);

// Read out all histogram 
// tapi.dspBlockDumpFile(0, 0, 0, 0xa00e2000, 0x800 * 128, 0, "timhistoall.bin");
// Read out part of histogram
// tapi.dspBlockDumpFile(0, 0, 0, 0xa00e2000 + 0x2000 * 128, 0x800 * 12, 0, "timhistoall.bin")
}
