{
// Double trigger for each module
// configuration changes as nmask
TScanDef dble;

dble.trigsPerBurst = 10000;
dble.configure(0, 0, 10, 1);

// dble.trigSequence.singleL1A();
dble.trigSequence.doubleL1A(10);

// dble.full = 0;
dble.bits32 = 1;
// dble.loopCalLine = 0;

// To one slave only
dble.distSlave = 0;
// dble.debug = 1;
// dble.tim = 0;
dble.nth = 2;
// dble.nth_rem = 0;  // Capture the first trigger
dble.nth_rem = 1;  // Capture the second trigger

// Mask L1ID check
// ERROR_MASK(0-1, 0-47)  bit 5
for(int e=0; e<2; e++) for(int f=0; f<48; f++) writeRegister(0x140+(0x30*e)+f, 5, 1, 1);

// Mask BCID check
// ERROR_MASK(0-1, 0-47)  bit 6
for(int e=0; e<2; e++) for(int f=0; f<48; f++) writeRegister(0x140+(0x30*e)+f, 6, 1, 1);

// tapi.setDebugOption("scan_error_trap_all");
// tapi.setDebugOption("scan_step_mode");

tapi.modifyABCDVar(11, 1.0);
tapi.modifyABCDVar(13, 0.0);
tapi.modifyABCDVar(14, 0.0);

tapi.modifyABCDVar(41, 1.0);  // QTHR Set to 1fC

tapi.doScan(dble);
tapi.awaitScan();
}
