// Version PWP 26.11.02 add st_set_idle() and st_kill_idle()
//                      remove st_idle()
// Transfer to SCTAPI

void buttons() {    // Needs to be same name as file for auto-start
  int ret;

  api_menu();

  printf(" ...ready for action!\n");
}


void api_menu(){

  TControlBar* bar = new TControlBar("vertical","SCT_API",0,0);
  bar->SetNumberOfColumns(2);

//    bar->AddButton("Startup","e->Startup();st_display_dcs()","RELOAD DEFAULT SYSTEM AND MODULE PARAMETERS");
//    bar->AddButton("Shutdown","e->Shutdown();st_display_dcs()","OPTO TX off, SCTLV off");
  bar->AddButton("Restart","api_restart()","Reload parameters and restart system");

  // Leave "Run" and "Stop" here because they're jolly useful - PWP 07.08.00
  bar->AddButton("Run Triggers","api_free()","Free Running Triggers");
  bar->AddButton("Stop Trigger","api_stopTrigs()","Stop Running Triggers");

  // Simple interactive configs and bursts
//    bar->AddButton("ChangeVariable","st_menu_change_variable()","Present the SetVariable panel");
  bar->AddButton("ABCD Tests","api_menu_macros()","Brief tests");

  // Change / Show configurations
  bar->AddButton("Show status","tapi.status()","Display current system configuration");
//    bar->AddButton("ShowModuleConfig","st_dialog_show_module_config()","Display current settings for a given module");

  bar->AddButton("OPTO TX off", "tapi.lasersOff()",  "Turn off VcSELs");
  bar->AddButton("BOC Status","api_boc_status()","Show status of BOC");

  bar->AddButton("Probe ROD", "api_probe()", "Show status of Modules attached to ROD");

//    bar->AddButton("DCSQuery","st_dcs_query()", "Query DCS for given module");

//    bar->AddButton("TestPrograms","st_menu_test_programs()","Diagnostic programs");
//    bar->AddButton("Status","e->PrintStatus()","System Status");
//    bar->AddButton("Documentation","st_docs()","Browse Documentation");
  bar->AddButton("Exit","api_exit()","Power off and Exit ROOT");
  bar->Show();

  //  gROOT->SaveContext();
}

void api_exit(){
  char c1;
 
  printf("\nDo you really want to exit the CINT/ROOT/SCTAPI environment? (y/n)\n");
  scanf("%c",&c1);
  if(c1!='y') return;

  tapi.shutdownAll();

  // The following method of exiting ST does so abruptly, without
  // the tedious infinite loop of error messages produced by .q
  gSystem->Exit(0,0);
}

void api_restart() {
  int runNumber = 0;
  printf("\nWhat run number do you want to restart with?\n");
  scanf("%d",&runNumber);

  tapi.initialiseAll(runNumber);
}

//  void st_set_idle(){
//    printf("Starting DCS monitor\n");
//    gROOT->Idle(10, "st_display_dcs();");

//    // Run it once to start off with
//    st_display_dcs();
//  }

//  void st_kill_idle(){
//    printf("Stopping DCS monitor\n");
//    gROOT->Idle(0, "st_display_dcs();");
//  }


// Keep these for later

void st_menu_analogue_scans(){

  TControlBar* abar = new TControlBar("vertical","ST scans");
  abar->SetNumberOfColumns(2);

  // Simple 1D scans using tburst.  Chips in data taking mode.
  // nb: scan loop must be in macro to permit dynamic histogram display updates
  abar->AddButton("Scan",           "st_scan(1,-1)","Repeat Last Scan");
  abar->AddButton("ScanElapsed",    "st_scan(1, 0)","Repeat Trigger Burst under the same conditions");
  abar->AddButton("ScanThreshold",  "st_scan(1, 1)","Scan Threshold in mV");
  abar->AddButton("ScanVCal",       "st_scan(1, 2)","Scan Calibration level in mV");
  //abar->AddButton("ScanQThreshold", "st_scan(1,41)","Scan Threshold in fC");
  abar->AddButton("ScanQCal",       "st_scan(1,42)","Scan Calibration level in fC");
  abar->AddButton("ScanStrobeDelay","st_scan(1, 3)","Scan On Chip Strobe Delay");
  abar->AddButton("ScanPreamp",     "st_scan(1, 4)","Scan Preamplifier Bias current in microA");
  abar->AddButton("ScanShaper",     "st_scan(1, 5)","Scan Shaper current in microA");
  abar->AddButton("ScanStreamDelay","st_scan(1,20)","Relative phase of CLK and DATA at MuSTARD");
  abar->AddButton("ScanClockDuty",  "st_scan(1,23)","Scan Clock Duty Cycle (NOT RECOMMENDED)");
  abar->AddButton("ScanComDelay",   "st_scan(1,25)","n BCOs between Reset and Command (SLOG only)");
  abar->AddButton("ScanPulseDelay", "st_scan(1,26)","n BCOs between Pulse Input and L1A");
  abar->AddButton("ScanTrigDelay",  "st_scan(1,27)","n BCOs between Cal Strobe and L1A ");
  abar->AddButton("ScanVcc",        "st_scan(1,31)","");
  abar->AddButton("ScanVdd",        "st_scan(1,33)","");
  abar->AddButton("ScanVLED",       "st_scan(1,35)","");

  if(e->nOPTIFs>0){
    abar->AddButton("ScanOPTO RX THR","st_scan(1,50)","");
    abar->AddButton("ScanOPTO TX DAC","st_scan(1,53)","");
  }

  abar->AddButton("ShowScan",       "e->ShowScan()",""); 
  abar->AddButton("ScanMenu",       "e->ScanMenu()","");

  abar->Show();
}

// And these

void st_menu_digital_scans(){

  TControlBar *dbar = new TControlBar("vertical","ST");

  // Simple 1D scans using rawburst.  Chips in send ID mode,
  // configs executed before each trigger.  Returned data is
  // compared against the expected result and errors totalled.
  dbar->AddButton("Scan",           "st_scan(6,-1)","Repeat Last Scan"); 
  dbar->AddButton("ScanStreamDelay","st_scan(6,20)","");
  dbar->AddButton("ScanClockDuty",  "st_scan(6,23)","");
  dbar->AddButton("ScanVdd",        "st_scan(6,33)","");
  dbar->AddButton("ScanVLED",       "st_scan(6,35)","");
//    dbar->AddButton("ShowScan",       "e->ShowScan()",""); 
//    dbar->AddButton("ScanMenu",       "e->ScanMenu()","");

  dbar->Show();
}

void api_menu_macros(){

  TControlBar* mbar = new TControlBar("vertical","SCTAPI Macros");

//    if(e->nSCTHV>0){
//      mbar->AddButton("IV Curve",         "st_iv()","Record the IV characteristic");
//    }
//    mbar->AddButton("Set Stream Delay", "st_tm()","Automatic Adjustment of Stream Delay");
//    mbar->AddButton("Hard Reset Tests", "st_hr()","Verify Hard Reset Functionality");
//    mbar->AddButton("Full Bypass Test", "st_fbt()","Verify Bypass Functionality");
//    mbar->AddButton("Redundancy Test",  "st_rt()","Check Redundant Clock and Command");
//    mbar->AddButton("Pipeline Test",    "st_pt()","Find dead cells in the pipeline");
  mbar->AddButton("Do strobe Delay", "api_sd()","Automatic Adjustment of Strobe Delay");
  mbar->AddButton("Three Point Gain", "api_tpg()","Fast measurement of gain and noise");
//    mbar->AddButton("Trim Range",       "st_tr()","Trimming, all four ranges");
//    mbar->AddButton("Trim Scan",        "st_ts()","Automatic Trimming");
  mbar->AddButton("Response Curve",   "api_rc()","");
  mbar->AddButton("NMask scan",   "api_nmask()","");
//    mbar->AddButton("Noise Occupancy",  "st_no()","");
//    mbar->AddButton("Timewalk",         "st_tw()","");

//    mbar->AddButton("Characterisation Sequence", "st_characterisation()","Full Test Sequence"); 
//    mbar->AddButton("Confirmation Sequence",     "st_confirmation()","Short Test Sequence");
 
//    mbar->AddButton("Endcap Hybrid LTT","st_eltt()","LTT (cold & warm) of Endcap Hybrids"); 
//    mbar->AddButton("Hybrid Warm LTT",  "st_hltt()","Warm Long Term Test of Barrel Hybrids"); 
//    mbar->AddButton("Hybrid Cold LTT",  "st_cltt()","Cold Long Term Test of Barrel Hybrids"); 
//    mbar->AddButton("Module LTT",       "st_mltt()","Long Term Test of Modules"); 
//    mbar->AddButton("IV LTT",           "st_ivltt()","Long Term Test of Detector Leakage Current"); 
 
  mbar->Show();
}

void st_menu_change_trigger(){

  TControlBar* trbar = new TControlBar("vertical","ST trigger");
  trbar->SetNumberOfColumns(1);

  trbar->AddButton("Set ntrigs",    "st_dialog_set_ntrigs()", "No. Triggers per burst"); 
  trbar->AddButton("L1A",           "st_menu_set_trigger(0)", "0 - using CLOAC"); 
  trbar->AddButton("CAL+L1A",       "st_menu_set_trigger(3)", "3 - using CLOAC");
  trbar->AddButton("PULSE+L1A",     "st_menu_set_trigger(20)","20 - using CLOAC");
  trbar->AddButton("Pretrigger+L1A","st_menu_set_trigger(30)","30 - PT, COM_DELAY, L1A"); 
  trbar->AddButton("BCR+L1A",       "st_menu_set_trigger(32)","32 - PT/BCR, COM_DELAY, L1A");
  trbar->AddButton("BCR+CAL+L1A",   "st_menu_set_trigger(34)","34 - PT/BCR, COM_DELAY, CAL, TRIG_DELAY, L1A");
  trbar->AddButton("BCR+PULSE+L1A", "st_menu_set_trigger(36)","36 - PT/BCR, COM_DELAY, CAL, PULSE_DELAY, L1A");
  trbar->AddButton("SR+L1A",        "st_menu_set_trigger(31)","31 - PT/SR, COM_DELAY, L1A");
  trbar->AddButton("SR+CAL+L1A",    "st_menu_set_trigger(33)","33 - PT/SR, COM_DELAY, CAL, TRIG_DELAY, L1A");
  trbar->AddButton("SR+PULSE+L1A",  "st_menu_set_trigger(35)","35 - PT/SR, COM_DELAY, CAL, PULSE_DELAY, L1A");

  trbar->AddButton("USER",          "st_menu_set_trigger(39)","39 - User sequence: file 'sctvar/config/slog.txt'");

  trbar->AddButton("8*L1A",         "st_menu_set_trigger(40)","40 - 8 Consecutive L1A");
  trbar->AddButton("SR+(8*L1A)",    "st_menu_set_trigger(41)","41 - SR, 8 Consecutive L1A");
  trbar->AddButton("SR+CAL+(8*L1A)","st_menu_set_trigger(43)","43 - SR, CAL,8 Consecutive L1A");
  trbar->AddButton("SR+PULSE+(8*L1A)", "st_menu_set_trigger(45)","45 - SR, PULSE,8 Consecutive L1A");

  trbar->AddButton("SR+(n*L1A)",    "st_menu_set_trigger(52)","52 - SR, n spaced L1A");
  trbar->AddButton("SR+CAL+(n*L1A)","st_menu_set_trigger(51)","51 - SR, CAL, n spaced L1A");
  trbar->AddButton("SR+PULSE+(n*L1A)", "st_menu_set_trigger(50)","50 - SR, PULSE,n spaced L1A");

  trbar->AddButton("do_cal_loop",   "st_menu_do_cal_loop(1)", "Loop over four cal lines");
  trbar->AddButton("skip_cal_loop", "st_menu_do_cal_loop(0)", "Single cal line only"); 
  trbar->Show();
}

void st_scan(short burst_type, short scan_type){
  TScanDef scan;

  // The Basic Scan Routine!!
  // Revised PWP 09.05.01 to allow:
  //   Adjustment of burst_ntrigs during NO scans
  //   Autostop

  int stop_loop = 0;
  int n_to_continue=0;
  short n, fitf;

//    st_start_stopper();  // start stop dialog
  scan.scanVariable = scan_type;

  stop_loop = 0;

  tapi.doScan(scan);
}

void api_free() {
  tapi.freeTriggers(getPartition(), getCrate(), 100);
}

void api_stopTrigs() {
  tapi.stopTriggers(getPartition(), getCrate());
}

void api_boc_status() {
  tapi.printBOCSetup(getPartition(), getCrate(), getRodNumber());
}

void api_probe() {
  tapi.probe(getPartition(), getCrate(), getRodNumber());
}

//  void st_display_dcs() {

//    char s[128],t[128];
//    int col = 17;
//    int n, npan, ipan, nmodppan;

//    TCanvas *pburst[4];
//    TPad *pburst_text[4];

//    nmodppan = e->num_panelmods;
//    npan = (e->num_showmods-1)/nmodppan+1;
//    if(npan > 4) npan = 4;

//    e->DCSQuery(); // update information for all present modules
//                   // not just for e->num_showmods  PWP 11.02.03

//    for(ipan=0;ipan<npan;ipan++){
//      sprintf(t,"pburst%d",ipan);
//      pburst[ipan] = (TCanvas*) gROOT->FindObject(t);
//      if(pburst[ipan]==0){
//        st_styles();
//        if(npan == 1)
//          sprintf(s,"Burst Display  Run %d", e->runnum);
//        else 
//          sprintf(s,"Burst Display  Run %d Modules %d-%d", e->runnum,ipan*nmodppan,(ipan+1)*nmodppan-1);
//        pburst[ipan] = new TCanvas(t,s,1100,750);
//        pburst[ipan]->SetFillColor(18);
//      }
//      pburst[ipan]->cd();

//      sprintf(t,"pburst_text%d",ipan);
//      pburst_text[ipan] = (TPad*) gROOT->FindObject(t);
//      if(pburst_text[ipan]==0){
//        pburst[ipan]->cd();
//        pburst_text[ipan] = new TPad(t,"Burst Text Pad", 0.9,0.0,1.0,0.88,col);
//        pburst_text[ipan]->Draw();
//        pburst_text[ipan]->cd();
//        pburst_text[ipan]->Divide(1,nmodppan,0,0);
//      }

//      for (n=ipan*nmodppan; n<e->num_showmods && n<(ipan+1)*nmodppan; n++){
//        pburst_text[ipan]->cd(n-ipan*nmodppan+1);
//        gPad->Clear();
//        e->m[n]->GetDCSBurstText()->Draw();
//      }
//      pburst[ipan]->Modified();
//      pburst[ipan]->Update();
//    }
//  }

//  void st_save_scan(TFile* out=0, Int_t accbst=0) {

//    int n;
//    char fname[128];
//    char mname[32];
//    Float_t tmp[6];
//    TGraph* gr;
//    TH1F* haccbst=0;

//    int write_fits=0;

//    // this function should be viewed as purely temporary... famous last words !

//    sprintf(fname,"%sstrun%d_%d.root",DATA_DIRECTORY,e->runnum,e->scannum);
//    if(out==0) out = new TFile(fname,"RECREATE");

//    TDatime *dt = new TDatime;
//    TObjString *dts = new TObjString(dt->AsString());
//    TObjString *pls = new TObjString(LOCATION_NAME);
//    TObjString *host= new TObjString(gSystem->Getenv("COMPUTERNAME"));
//    TObjString *user= new TObjString(gSystem->Getenv("SCTDB_USER"));

//    dts->Write("Time");
//    pls->Write("Place");
//    host->Write("Host");
//    user->Write("User");

//    for (n=0; n<e->GetMaxModules(); n++){
//      if(e->m[n]->scan_fitted){
//        write_fits++;
//      }
//    }

//    // write environmental info to file
//    if(st_get_dcsrem(tmp)){
//      sprintf(fname,"%3.1f",tmp[0]);
//      TObjString * et1s = new TObjString(fname);
//      et1s->Write("ET1");
//      delete et1s;
    
//      sprintf(fname,"%3.1f",tmp[1]);
//      TObjString * et2s = new TObjString(fname);
//      et2s->Write("ET2");
//      delete et2s;
    
//      sprintf(fname,"%3.1f",tmp[2]);
//      TObjString * et3s = new TObjString(fname);
//      et3s->Write("ET3");
//      delete et3s;
    
//      sprintf(fname,"%3.1f",tmp[3]);
//      TObjString * hums = new TObjString(fname);
//      hums->Write("HUM");
//      delete hums;
    
//      sprintf(fname,"%3.1f",tmp[4]);
//      TObjString * pips = new TObjString(fname);
//      pips->Write("PIPE");
//      delete pips;
//    }

//    for (n=0; n<e->GetMaxModules(); n++){
//    //  if(e->m[n]->present){  // only write histograms for present modules

//        e->GetModuleName(n,mname);
//        TObjString * mns = new TObjString(mname);
//        mns->Write("ModuleName");
//        delete mns;

//        e->GetDeviceType(n,fname);
//        TObjString * dut = new TObjString(fname);
//        dut->Write("DUT");
//        delete dut;

//        // sprintf formats in this section revised PWP 28.03.02
//        sprintf(fname,"%2.1f",e->m[n]->DCS->T1);
//        TObjString * t1s = new TObjString(fname);
//        t1s->Write("T0");
//        delete t1s;

//        sprintf(fname,"%2.1f",e->m[n]->DCS->T2);
//        TObjString * t2s = new TObjString(fname);
//        t2s->Write("T1");
//        delete t2s;

//        sprintf(fname,"%3.1f",e->m[n]->DCS->vdet);
//        TObjString * vdets = new TObjString(fname);
//        vdets->Write("VDET");
//        delete vdets;

//        sprintf(fname,"%1.2f",e->m[n]->DCS->idet);
//        TObjString * idets = new TObjString(fname);
//        idets->Write("IDET");
//        delete idets;

//        sprintf(fname,"%1.2f",e->m[n]->DCS->vcc);
//        TObjString * vccs = new TObjString(fname);
//        vccs->Write("VCC");
//        delete vccs;

//        sprintf(fname,"%3.0f",e->m[n]->DCS->icc);
//        TObjString * iccs = new TObjString(fname);
//        iccs->Write("ICC");
//        delete iccs;

//        sprintf(fname,"%1.2f",e->m[n]->DCS->vdd);
//        TObjString * vdds = new TObjString(fname);
//        vdds->Write("VDD");
//        delete vdds;

//        sprintf(fname,"%3.0f",e->m[n]->DCS->idd);
//        TObjString * idds = new TObjString(fname);
//        idds->Write("IDD");
//        delete idds;

//        e->m[n]->DCS->Write();  //stream the DCS object

//        if(accbst && e->m[n]->present){
//          e->m[n]->h_accbst0->Write();
//          e->m[n]->h_accbst1->Write();
//        }
//        else{
//          e->m[n]->h_scan0->Write("h_scan0");
//          e->m[n]->h_scan1->Write("h_scan1");

//          if(e->nSCTLV>0){
//            gr = e->m[n]->GetIddGraph();
//            gr->Write("Idd");
//            gr = e->m[n]->GetIccGraph();
//            gr->Write("Icc");
//          }
//          if(e->nSCTHV>0 || e->m[n]->DCS->hv_source==2){
//            gr = e->m[n]->GetIdetGraph();
//            gr->Write("Idet");
//          }

//          if(write_fits){
//            e->m[n]->h_mean0->Write("h_mean0");
//            e->m[n]->h_mean1->Write("h_mean1");
//            e->m[n]->h_sigma0->Write("h_sigma0");
//            e->m[n]->h_sigma1->Write("h_sigma1");
//            e->m[n]->h_code0->Write("h_code0");
//            e->m[n]->h_code1->Write("h_code1");
//            e->m[n]->h_chisq0->Write("h_chisq0");
//            e->m[n]->h_chisq1->Write("h_chisq1");
//            e->m[n]->h_fom0->Write("h_fom0");
//            e->m[n]->h_fom1->Write("h_fom1");
//          }
//        }

//        // TODO: Write the next three hists at each EOB
//        // This code will write the hists to file only
//        // for the LAST burst of each scan

//        if((e->burst_type == 100)||(e->burst_type == 102)||(e->burst_type==21)) { // decoded burst or decoded vburst
//          e->m[n]->h_cluster0->Write("h_cluster0");
//          e->m[n]->h_cluster1->Write("h_cluster1");
//          e->m[n]->h_corr->Write("h_corr");

//          if(e->do_fill_evtree){
//            if(e->m[n]->evtree!=0){
//              sprintf(fname,"EvTree_m%d",n);
//              e->m[n]->evtree->Write(fname);
//            }
//          }
//        }
//    //  } 
//    }

//    e->h_scan_tsent->Write();
//    for (n=0; n<e->nMuSTARDs; n++){
//      e->h_scan_evcnt[n]->Write("h_scan_evcnt");
//      e->h_scan_ercnt[n]->Write("h_scan_ercnt");
//      e->h_scan_tocnt[n]->Write("h_scan_tocnt");
//      e->h_scan_xecnt[n]->Write("h_scan_xecnt");
//    }

//    out->Close();


//    sprintf(fname, "%sstlog%d.txt",DATA_DIRECTORY,e->runnum);
  
//    FILE *logfile;
//    logfile = fopen(fname,"a+");

//    fprintf(logfile,"runnum %u\n",e->runnum);
//    fprintf(logfile,"scannum %u\n",e->scannum);
//    fprintf(logfile,"date %u\n",dt->GetDate());
//    fprintf(logfile,"time %u\n",dt->GetTime());
//    fprintf(logfile,"scan_type %u\n",e->scan_type);
//    fprintf(logfile,"scan_start %6.2f\n",e->scan_start);
//    fprintf(logfile,"scan_stop %6.2f\n",e->scan_stop);
//    fprintf(logfile,"scan_step %6.2f\n",e->scan_step);
//    fprintf(logfile,"run_tsent %u\n",e->run_tsent);
//    fprintf(logfile,"run_evcnt %u\n",e->run_evcnt);
//    fprintf(logfile,"run_ercnt %u\n",e->run_ercnt);
//    fprintf(logfile,"run_tocnt %u\n",e->run_tocnt);
 
//    fclose(logfile);

//    delete dt; // PWP 20.12.01
//    delete dts;
//    delete pls;
//    delete host;
//    delete user;
//  }

//  void st_dcs_query() {
//    int moi;

//    printf("Show DCS for module (int) ?");
//    scanf("%d",&moi);

//    if((moi>=0)&&(moi<e->GetMaxModules())){
//      e->m[moi]->DCS->Print();
//    } else {
//     printf("Sorry, module %d out of range\n",moi);
//    }
//  }

//  void st_dcs_log() {
//    int moi;
//    float tmp[6];
  
//    printf("\nModule-specific DCS-Information:\n\n");
//    printf("Module\t\tVcc\tIcc\tVdd\tIdd\tVdet\tIdet\tThyb1\tThyb2\n");

//    for(moi=0;moi<e->GetMaxModules();moi++){ // was e->num_showmods PWP 11.02.03
//      if(e->m[moi]->present) {
//        e->m[moi]->DCS->Query();
//        printf("%s\t%.2f\t%.0f\t%.2f\t%.0f\t%.1f\t%.2f\t%.2f\t%.2f\n",
//               e->m[moi]->name,e->m[moi]->DCS->vcc,e->m[moi]->DCS->icc,
//               e->m[moi]->DCS->vdd,e->m[moi]->DCS->idd,
//               e->m[moi]->DCS->vdet,e->m[moi]->DCS->idet,
//               e->m[moi]->DCS->T1,e->m[moi]->DCS->T2);
//      }
//    }

//    if(st_get_dcsrem(tmp)){
//      printf("\nEnvironmental DCS-Information:\n\n");
//      printf("Tamb1\tTamb2\tTamb3\tHum\tTpipe\n");
//      printf("%.1f\t%.1f\t%.1f\t%.1f\t%.1f\n\n",
//             tmp[0],tmp[1],tmp[2],tmp[3],tmp[4]);
//    }

//  }

//  void st_show_sc() {
//    int moi,loi;

//    printf("Show s curves for module (int) ?");
//    scanf("%d",&moi);
  
//    printf("link ?");
//    scanf("%d",&loi);
  
//    gROOT->ProcessLine(".L stan_scurves.cpp");
//    stan_scurves(moi,loi);
//  }


// links to production test macros
// added PWP 16.11.00

//  void st_tm(){
//    gROOT->ProcessLine(".L StreamDelay.cpp");
//    StreamDelay(0);
//  }

//  void st_iv(){
//    gROOT->ProcessLine(".L IVCurve.cpp");
//    IVCurve();
//  }

//  void st_hr(){
//    gROOT->ProcessLine(".L HardReset.cpp");
//    HardReset();
//  }

//  void st_fbt(){
//      gROOT->ProcessLine(".L FullBypassTest.cpp");
//      FullBypassTest();
//  }

//  void st_bt(){
//    gROOT->ProcessLine(".L BypassTest.cpp");
//    BypassTest();
//  }

//  void st_rt(){
//    gROOT->ProcessLine(".L RedundancyTest.cpp");
//    RedundancyTest();
//  }

//  void st_pt(){
//    gROOT->ProcessLine(".L PipelineTest.cpp");
//    PipelineTest();
//  }

void api_sd(){
  gROOT->ProcessLine(".X strobe.cxx");
  //  StrobeDelay(1);
}

void api_tpg(){
  gROOT->ProcessLine(".X 3pt.cxx");
}

//  void st_tr(){
//    gROOT->ProcessLine(".L TrimRange.cxx");
//    TrimRange();
//  }

void api_rc(){
  gROOT->ProcessLine(".X reponse.cxx");
}

void api_nmask(){
  gROOT->ProcessLine(".X nmask.cxx");
}

//  void st_no(Int_t go_slow=0, Int_t do_qthr=0){
//    gROOT->ProcessLine(".L No.cxx");
//    No(go_slow,do_qthr);
//  }

//  void st_tw(){
//    gROOT->ProcessLine(".L Timewalk.cxx");
//    Timewalk(1); // find 1fC point by threshold scan
//  }

//  void st_characterisation(){
//    gROOT->ProcessLine(".L CharacterisationTest.cxx");
//    CharacterisationTest();
//  }

//  void st_confirmation(){
//    gROOT->ProcessLine(".L ConfirmationTest.cxx");
//    ConfirmationTest();
//  }

//  void st_cltt(){
//    gROOT->ProcessLine(".L HybridColdTest.cxx");
//    HybridColdTest();
//  }

int buttons_partition = 0;
int buttons_crate = 0;
int buttons_rod = 0;

int getPartition() {
  return buttons_partition;
}

int getCrate() {
  return buttons_crate;
}

int getRodNumber() {
  return buttons_rod;
}
