#include <iostream>                 // XXX This is for debug only!

#include "RodCrate/RodModule.h"
#include "RodCrate/BocCard.h"
#include "RodCrate/TimModule.h"              // For TimMaskFrequency

#include "crateImpl.h"
#include "primListWrapper.h"

namespace SctApi {
#if USE_THREADS
  void CrateImpl::pollingLoop() {
    std::cout << "POLL: Starting Polling loop\n";

    // Tell RODs not to send their own primitive lists
    bool synchRods = false;
    // Which RODs are waiting for a new primitive lists
    int synched = 0;

    int waitCount = 0;

    // Loop over all RODs 
    while(!m_stopPolling) {
//       std::cout << "POLL: Start of loop\n";
      if(!m_enablePolling) {
        do {
          usleep(1000);
        } while(!m_enablePolling);
      }

      // This mask is rebuilt on each iteration (just in case someone removes a ROD on the fly...)
      int rodMask = 0;
      // Count how many RODs were polled
      int rods = 0;

      // Theres a primlist to go to all RODs
#warning "This takes priority over all other lists..."
      // First wait for RODs to finish their previous lists
      {
        boost::mutex::scoped_lock lock(primQueue_mutex);
        if(listQueueAll.size() > 0) {
//           std::cout << "Have new all primitive\n";
          if(synchRods == false) {
            synchRods = true;
            synched = 0;
//             std::cout << "Synching RODs for all primitive\n";
          }
        }
      }

      // For each rod:
      for(RodMap::iterator i=rodMap.begin();i!=rodMap.end();i++){
        SctPixelRod::RodModule &rod = *(i->second.second);
        RodStatus &status = *(i->second.first);
        //   Get locks
        {
          boost::mutex::scoped_lock statLock(status.mutex);
          SctPixelRod::PrimState oldPrimState = rod.getPrimState();

          try {
            boost::mutex::scoped_lock lock(vmeMutex);
            //   PrimHandler
            rod.primHandler();
          } catch (SctPixelRod::BaseException &ex) {
            std::cerr << "Exception in polling loop (prim handler): " << ex << std::endl;
#warning "Should do something here!"
          } catch (...) {
            std::cerr << "Unknown exception in polling loop (prim handler)\n";
#warning "Should do something here!"
          } // Keep VME lock for duration of try

//             std::cout << "POLL: PrimHandler state " << rod.getPrimState() << "\n" ;
//             std::cout << "POLL: Mystate " << status.currState << "\n" ;
//             std::cout << "POLL: Queue size " << status.listQueue.size() << "\n" ;
          SctPixelRod::PrimState newPState = rod.getPrimState();

          if((newPState == SctPixelRod::PRIM_IDLE || newPState == SctPixelRod::PRIM_WAITING)) {
            if(synchRods) {
              // This ROD is waiting for the all ROD list
              synched |= 1 << i->first;

//               std::cout << "ROD " << i->first << " ready for All primitive\n";
            } else if(status.currState == MYPRIM_STATE_LOADED) {
              boost::shared_ptr<PrimListWrapper> nextPrimList;
              {
                boost::mutex::scoped_lock lock(primQueue_mutex);
                if(status.listQueue.size() > 0) {
                  // Send list from personal queue
                  nextPrimList = status.listQueue.front();
                  status.listQueue.pop_front();
                }
              }

              if(nextPrimList) {
                try {
                  boost::mutex::scoped_lock lock(vmeMutex);

                  rod.sendPrimList(nextPrimList->list.get());   // Pass in auto_ptr (only used briefly)
                } catch (SctPixelRod::BaseException &ex) {
                  std::cerr << "Exception in polling loop (send prim list): " << ex << std::endl;
#warning "Should do something here!"
                } catch(...) {
                  std::cerr << "Unknown exception in polling loop (send prim list)\n";
#warning "Should do something here!"
                }
              }
            } else {
              // No new prim lists
            }
          }

          if(oldPrimState != newPState) {
            //               std::cout << "New primHandler state " << newPState << "\n" ;

            // Just entered new state...
            switch(newPState) {
            case SctPixelRod::PRIM_LOADED:
            case SctPixelRod::PRIM_EXECUTING:
              status.currState = MYPRIM_STATE_EXECUTING;
//               std::cout << "POLL: STATE: Changing state to executing\n";
              break;
            case SctPixelRod::PRIM_IDLE:
            case SctPixelRod::PRIM_WAITING:
              status.currState = MYPRIM_STATE_COMPLETE;
//               std::cout << "POLL: STATE: Change state to COMPLETE\n";
              break;
            case SctPixelRod::PRIM_PAUSED:
              break;
            }
          }

          try {
            boost::mutex::scoped_lock lock(vmeMutex);
            //   TextHandler
            SctPixelRod::TextBuffState newTState = rod.textHandler();

            while (newTState == SctPixelRod::TEXT_RQ_SET) {
              doTextBuffer(rod);
              // Text State now TEXT_IDLE
              // Needs checking for more text buffers
              newTState = rod.textHandler();
            }
          } catch (SctPixelRod::BaseException &ex) {
            std::cerr << "Exception in polling loop (text handler): " << ex << std::endl;
#warning "Should do something here!"
          } catch (...) {
            std::cerr << "Unknown exception in polling loop (text handler)\n";
#warning "Should do something here!"
          }
//           status.currState = rod.getPrimState();
        }        // Give status lock

        // Don't do when have any locks...
        sched_yield();

        rods ++;
        rodMask |= 1 << i->first;
      }         // Next ROD

//       std::cout << "Polled " << rods << " RODs\n";

      // All RODs are ready for the list
      if(synchRods && synched == rodMask) {
//         std::cout << "All primitive condition met\n";

        boost::shared_ptr<PrimListWrapper> globalPrimList;
        {
          boost::mutex::scoped_lock lock(primQueue_mutex);
          globalPrimList = listQueueAll.front();
          listQueueAll.pop_front();
        }

        if(globalPrimList) {
          // For each rod:
          for(RodMap::iterator i=rodMap.begin();i!=rodMap.end();i++){
            SctPixelRod::RodModule &rod = *(i->second.second);

//             std::cout << "Adding All primitive to ROD " << i->first << std::endl;

            RodStatus &status = *(i->second.first);
            //   Get locks
            {
              boost::mutex::scoped_lock statLock(status.mutex);
              try {
                boost::mutex::scoped_lock lock(vmeMutex);

                rod.sendPrimList(globalPrimList->list.get());   // Pass in pointer (only used briefly)

//                 std::cerr << "POLL: Sending all primitive to " << i->first << "\n";

                // So it executes it next time around
                status.currState = MYPRIM_STATE_LOADED;
              } catch (SctPixelRod::BaseException &ex) {
                std::cerr << "Exception in polling loop (global send prim list): " << ex << std::endl;
#warning "Should do something here!"
              } catch (...) {
                std::cerr << "Unknown exception in polling loop (global send prim list)\n";
#warning "Should do something here!"
              }
            }
          }
        }

        // Sent primlist
        synchRods = false;
      }

      if(m_stopPolling) {
        break;
      }

      {
        // Make sure nobody adds to the queues while they're being checked!
        boost::mutex::scoped_lock lock(primQueue_mutex);

        bool doWait = true;

        // For each rod:
        for(RodMap::iterator i=rodMap.begin();i!=rodMap.end();i++){
          SctPixelRod::RodModule &rod = *(i->second.second);
          RodStatus &status = *(i->second.first);

          if(status.currState == MYPRIM_STATE_COMPLETE) {
            if(status.listQueue.size() !=  0) {
              doWait = false;
              break; // The for loop
            }
          } else {
            // Prim still executing
            doWait = false;
          }
        }

        // Don't be too eager to block as there may be text buffers arriving...
        if(doWait) {
//           std::cout << "POLL: Wait\n";
          waitCount ++;
          if(waitCount>5) {
            usleep(10);
          } else if(waitCount>10) {
            usleep(100);
          } else if(waitCount>20) {
            sleep(1);
//           } else if(waitCount>20) {
//             if(listQueueAll.size() == 0) {
//               std::cout << "Polling loop blocking\n";
//               primQueue_notEmpty.wait(lock);
//               waitCount = 0;
//             }
          }
        }
      }

      //      usleep(1000);

//       std::cout << "Polling loop looping\n";
    }  // While (1)
  }
#endif
}
