#include <boost/shared_ptr.hpp>

#include "primListWrapper.h"

// This defines ABCDModule (a typedef)
#include <CommonWithDsp/sctStructure.h>

namespace SctApi {
namespace Utility {
  class MemoryBlock;
}

class PrimBuilder {
 private:
  // These are really not allowed!
  PrimBuilder(const PrimBuilder&);
  PrimBuilder& operator=(const PrimBuilder&);

 protected:
  // But this one is internally (helps with gcc warning for factories)
  PrimBuilder();

 public:
  /// Build a slave primitive list onto a master primitive list
  /** 
      Put a send slave list primitive into a primitive list
      Follow it by a start list primitive
   */
  void slavePrimList(boost::shared_ptr<PrimListWrapper> primList, boost::shared_ptr<PrimListWrapper> prim, 
                          unsigned int slaveNumber, bool await, bool response);

  void startSlaveList(boost::shared_ptr<PrimListWrapper> primList, unsigned int slaveNumber, bool await, bool response);

  void echo(boost::shared_ptr<PrimListWrapper> prim, Utility::MemoryBlock block);

  void flashLed(boost::shared_ptr<PrimListWrapper> prim, int period, int flashes);

  void startSlave(boost::shared_ptr<PrimListWrapper> prim, int s);

  void readFifo(boost::shared_ptr<PrimListWrapper> prim, int id, int bank, int elems);

  void pollRegister(boost::shared_ptr<PrimListWrapper> prim, int r, int off, int width, int val, int timeout);

  void taskOp(boost::shared_ptr<PrimListWrapper> prim, int typ, int op, int data);

  void readRegister(boost::shared_ptr<PrimListWrapper> prim, int r);

  void writeRegister(boost::shared_ptr<PrimListWrapper> prim, int r, int off, int wid, int value);

  void buildStream(boost::shared_ptr<PrimListWrapper> primList, int port);

  void sendStream(boost::shared_ptr<PrimListWrapper> primList, int cmdBuff, bool capture = 0);

  void startEvTrap(boost::shared_ptr<PrimListWrapper> primList);

  void stopEvTrap(boost::shared_ptr<PrimListWrapper> primList);

  void setMemory(boost::shared_ptr<PrimListWrapper> primList, unsigned long address, unsigned long words, long value);

  void readSlaveMemory(boost::shared_ptr<PrimListWrapper> primList, unsigned long slave, unsigned long address, unsigned long words);

  void writeSlaveMemory(boost::shared_ptr<PrimListWrapper> primList, unsigned long slave, unsigned long address, unsigned long words, unsigned long *data);

  void readModuleData(boost::shared_ptr<PrimListWrapper> primList, int bank, int channel);

  void writeModuleData(boost::shared_ptr<PrimListWrapper> primList, const ABCDModule* module, int bank, int channel);

  void sendConfig(boost::shared_ptr<PrimListWrapper>, 
                  int port, int capture, int module0, int module1, int chip, int setLinks, int restore, 
                  int bank, int group, int data, int active, int enableData);

  void writeModuleVariable(boost::shared_ptr<PrimListWrapper>, int bank, int group, int module, int chip, int type, float val);

  void rodMode(boost::shared_ptr<PrimListWrapper> rodModeList, 
               int mode, int flag, int fifoSetup, int nBits, int delay, int message);

  void moduleMask(boost::shared_ptr<PrimListWrapper> maskList, 
                  int module, int port, int useStructSet, int passOn, int slvs,
                  int cmdLine, int dataLine0, int dataLine1, // 2 and 3 only for pixels
                  int cfg, int modMask0, int modMask1, int maskType, int storage, int maskSet);

  void masksFromConfig(boost::shared_ptr<PrimListWrapper> maskList, int port);

  void masksToSlaves(boost::shared_ptr<PrimListWrapper> maskList, int slvBits);

  void bocHistogram(boost::shared_ptr<PrimListWrapper> primList, int samples, int numLoops);

  void setTrigger(boost::shared_ptr<PrimListWrapper> primList, int currentBin, int histogramSet);

  static PrimBuilder& instance();
  static PrimBuilder *singleton;
};
}
