#include "processor.h"

/// High level access to DCS
class DCSAccess {
 public:
  /// Or could just check signal received after a trigger
  virtual bool checkPowerOn(UINT32 mid) = 0;

  /// Move all modules to low LV analogue voltage
  virtual void toStandby1() = 0;

  /// Move all modules to standard LV voltages, HV to low voltage
  virtual void toStandby2() = 0;

  /// Move all modules to HV voltage on
  virtual void toHVPowerOn() = 0;

  /// Check select line
  virtual bool checkSelectLine() = 0;

  /// Give all modules a hard reset 
  virtual void hardResetAll() = 0;
};

/// Provide dummy answers to everything...
class DCSAccessDummy : public DCSAccess {
 public:
  bool checkPowerOn(UINT32 mid);

  void toStandby1();

  void toStandby2();

  void toHVPowerOn();

  bool checkSelectLine();

  void hardResetAll();
};
