#include "TestResult.h"
#include "FitScanResult.h"
#include "RawScanResult.h"
#include "ConfigurationVariable.h"
#include "NullVariable.h"
#include "UniqueID.h"
#include "Sct/SctNames.h"
#include "Sct/IS/IOManagerIS.h"
#include "Sct/IS/IONameIS.h"
#include <algorithm>
#include <sstream>

using namespace std;
using namespace Sct;
using namespace Sct::IS;
using namespace boost;

namespace SctData {

TestResult::TestResult(const unsigned int runNumber, const string & moduleName,
		       const ConfigurationVariable& testVariable, const ConfigurationVariable& scanVariable) throw ()
                       : header(0, runNumber, moduleName, scanVariable), testVariable(&testVariable),
		       passed(false), problem(false) {
}


TestResult::TestResult() throw() : testVariable(&NullVariable::instance()),
    passed(false), problem(false) {
}

const ResultHeader& TestResult::getHeader() const {
    return header;
}
    
ResultHeader& TestResult::getHeader() {
    return header;
}

unsigned int TestResult::getRunNumber() const throw() {
    return getHeader().getRunNumber();
}

void TestResult::setRunNumber(unsigned int runNumber) throw() {
    getHeader().setRunNumber(runNumber);
}

string TestResult::getModuleName() const throw() {
    return getHeader().getModuleName();
}

void TestResult::setModuleName(string name) throw() {
    getHeader().setModuleName(name);
}

const DefectList& TestResult::getDefects() const throw() {
    return defects;
}

DefectList& TestResult::getDefects() throw() {
    return defects;
}

const ConfigurationVariable& TestResult::getScanVariable() const throw() {
    return getHeader().getVariable();
}

void TestResult::setScanVariable(const ConfigurationVariable& scanVariable) throw() {
    getHeader().setVariable(scanVariable);
}

const ConfigurationVariable& TestResult::getTestVariable() const throw() {
    return *testVariable;
}

void TestResult::setTestVariable(const ConfigurationVariable& testVariable) throw() {
    this->testVariable = &testVariable;
}

bool TestResult::getPassed() const throw() {
    return passed;
}

void TestResult::setPassed(bool passed) throw() {
    this->passed = passed;
}

bool TestResult::getProblem() const throw() {
    return problem;
}

void TestResult::setProblem(bool problem) throw() {
    this->problem = problem;
}

vector<string> TestResult::getComments() const throw() {
    return comments;
}

void TestResult::addComment(string comment) throw() {
    comments.push_back(comment);
}

void TestResult::addScan(const unsigned int scanNumber, const double testPoint) throw(LogicError) {
    if (data.size() == 0) {
	getHeader().setScanNumber(scanNumber);
    }
    data.push_back(ScanData(scanNumber, testPoint));
    sort(data.begin(), data.end());
}

string TestResult::getUniqueID() const throw(LogicError) {
    if (data.size() > 0) {
        return getHeader().getUniqueID();
    }
    throw IllegalStateError("TestResult::getUniqueID() : empty test result", __FILE__, __LINE__);
}

unsigned TestResult::getScanNumberAt(unsigned int i) const throw(LogicError) {
    if ( i>=data.size() )
        throw OutOfRangeError<unsigned>("TestPoint::getScanNumberAt", __FILE__, __LINE__,i,0,data.size()-1);
    return data[i].scanNumber;
}

double TestResult::getTestPointAt(unsigned int i) const throw(LogicError) {
    if ( i>=data.size() )
        throw OutOfRangeError<unsigned>("TestPoint::getTestPointAt", __FILE__, __LINE__,i,0,data.size()-1);
    return data[i].testPoint;
}

unsigned int TestResult::getIndex(unsigned int scanNumber) const throw(LogicError) {
    vector<ScanData>::const_iterator i=find(data.begin(), data.end(), scanNumber);
    if (i==data.end() ) {
        ostringstream text;
        text << "TestResult::findScanData scan not found scanNumber="<< scanNumber;
        throw InvalidArgumentError( text.str(), __FILE__, __LINE__ );
    }
    return i-data.begin();
}

/// Functions of the inner class `scanData'
TestResult::ScanData::ScanData(const unsigned int scanNumber, const double testPoint) throw()
        : scanNumber(scanNumber), testPoint(testPoint) {}

bool TestResult::ScanData::operator<(const ScanData& s) const throw() {
    if (this->scanNumber<s.scanNumber)
        return true;
    return false;
}

bool TestResult::ScanData::operator>(const ScanData& s) const throw() {
    if (this->scanNumber>s.scanNumber)
        return true;
    return false;
}

bool TestResult::ScanData::operator==(const unsigned int aScanNumber) const throw() {
    if (this->scanNumber==aScanNumber)
        return true;
    return false;
}

void  TestResult::setDcsData(boost::shared_ptr<const DcsData> data){
  m_dcsData = data;
}

boost::shared_ptr<const DcsData> TestResult::getDcsData() const {
  return m_dcsData;
}

}
