#ifndef SCANRESULT_H
#define SCANRESULT_H

#include "Sct/Exception.h"
#include "ModuleConfiguration.h"
#include "ScanPoints.h"
#include "Result.h"

namespace SctData {
		
/**
This class represents all possible things what might come out of a ROD.
@author Matthew Palmer
@date 28/02/2003
*/
class ScanResult : public virtual Result {
public:
    /**
       Creates a ScanResult by copying the header and module configuration
       @note Nothrow
    */
    ScanResult(const ResultHeader& header, const ModuleConfiguration& moduleConfig, const ScanPoints& points);
    
    /**
       Copy constructor
       @note Nothrow
    */
    ScanResult(const ScanResult& copyMe);
        
    /**
       Retrieves the scan-header object
       @note Nothrow
    */
    virtual const ResultHeader& getHeader() const {return header;}
    /**
       Retrieves the scan-header object
       @note Nothrow
    */
    virtual ResultHeader& getHeader() {return header;}
    
    /**
       Returns the module configuration
       @note Nothrow
    */
    const ModuleConfiguration& getConfiguration() const {return moduleConfig;}
    /**
       Returns the configuration
       @note Nothrow
    */
    ModuleConfiguration& getConfiguration() {return moduleConfig;}
    
    /**
       Get the ScanPoints object
       @note Nothrow
    */
    const ScanPoints& getPoints() const throw() {return points;}
    /**
       Gets the ScanPoints object
       @note Nothrow
    */
    ScanPoints& getPoints() {return points;}
    
protected:
    ScanResult();								///< For IO use only.
    
private:
    ResultHeader header;					///< The ScanHeader that identifies this ScanResult.
    ModuleConfiguration moduleConfig;		///< The ModuleConfiguration of the module referred to in the header.
    ScanPoints points;					///< The scan points.
};
	

}
#endif //#ifndef SCANRESULT_H
