#ifndef RAWSCANRESULT_H
#define RAWSCANRESULT_H

#include "ScanResult.h"
#include "Sct/RangedVector.h"
#include <boost/shared_ptr.hpp>

class TH1;
class TH1D;
class TH2;
class TH2D;
using Sct::LogicError;
using boost::shared_ptr;

namespace SctData {

/**
 * A RawScanResult represents the raw data for a single scan.
 * Note that this object (like all others in the package) owns its members (i.e. it will delete them when it is deleted).
 * This can cause problems with the 4 argument constructor if you give it local vars!!!!
 * @author Matthew Palmer
 */
class RawScanResult : public ScanResult {
public:

    /** 
     * Creates a RawScanResult object with the given parameters
     * Takes ownership of the scan histograms
     */
    RawScanResult(const ResultHeader& scanInfo, const ModuleConfiguration& module, const ScanPoints& points, TH2D& scan_link0, TH2D& scan_link1) throw() ;

    /// Destroys this object and all its members.
    virtual ~RawScanResult() throw();
    
    //Overrides	
    virtual string getClassName() const throw() ;	
    virtual string getUniqueID() const throw() ;
    
    /// Gets the unique ID this class would have if it existed and was constructed with header.
    static string getUniqueID(const ResultHeader& header) throw() ;

    /**
     * Gets the scan data as a ROOT histogram. 
     * @return the scan data
     * @throw LogicError if not available
     * @param link should be 0 or 1
     */
    TH2D& getScanData(unsigned link) const throw(LogicError) ;

    /** returns number of occupancyPerEvent data histograms, usually 0 or 12 */
    unsigned nOccupancyPerEvent() const;

    /**
     * Gets the occupancy histogram data as a ROOT histogram. 
     * @return the scan data
     * @param chip should be 0 to 11
     * @throw LogicError if not available
     */
    TH2D& getOccupancyPerEvent(unsigned ichip) const throw(LogicError) ;

    /** 
     * Get the dataType, as defined in SctApi/dataTypes.h
     */
    UINT16 getDataType() const throw();

protected:    
    shared_ptr<TH2D> scanData_link0; 			///<Scan data for link 0
    shared_ptr<TH2D> scanData_link1; 			///<Scan data for link 1

    Sct::RangedVector<shared_ptr<TH2D> > occ_chip; 			///<Occupancy per event for chip
    
    UINT16 m_dataType;                                    ///< same as SctApi/dataTypes.h

private:
    friend class RawScanResultIOHelper;
    RawScanResult() throw() ; 				///< Constructor for IO use only
};
}
#endif //#ifndef RAWSCANRESULT_H


