#include "NPtGainTestResult.h"
#include "ResponseCurve.h"
#include "FitScanResult.h"
#include "CalChargeVariable.h"
#include "ThresholdVariable.h"
#include "Sct/SctParameters.h"

#include <sstream>

//ROOT includes
#include <TF1.h>
#include <TH2.h>
#include <TGraph.h>

using namespace std;

namespace SctData {

NPtGainTestResult::NPtGainTestResult() throw() : specialScanIndex(0), chipData("NPtGainTestResult::ChipData"), channelData("NPtGainTestResult::ChannelData") {
    chipData.resize(nChipModule);
    channelData.resize(nChannelModule);
}
    
NPtGainTestResult::NPtGainTestResult(unsigned int runNumber, const string & moduleName, 
				     const CalChargeVariable& testVariable, const ThresholdVariable& scanVariable) throw()
    : TestResult(runNumber, moduleName, testVariable, scanVariable), specialScanIndex(0),
    chipData("NPtGainTestResult::ChipData"), channelData("NPtGainTestResult::ChannelData") {
    chipData.resize(nChipModule);
    channelData.resize(nChannelModule);
}

NPtGainTestResult::~NPtGainTestResult() throw() {
    
}

string NPtGainTestResult::getClassName() const throw() {
    return "SctData::NPtGainTestResult";
}

void NPtGainTestResult::setSpecialScanPointValue(double pointValue) throw(LogicError) {
    for (unsigned int i=0; i<data.size(); ++i) {
        if (fabs(data[i].testPoint - pointValue) < 10e-6) {
            specialScanIndex = i;
            return;
        }
    }
    
    ostringstream text;
    text << "TestResult::setSpecialPoint cannot be set to " << pointValue;
    throw InvalidArgumentError( text.str(), __FILE__, __LINE__ );
}

void NPtGainTestResult::setChannelDataSize(unsigned int i) throw() {
    channelData.resize(i);
}

void NPtGainTestResult::setChipDataSize(unsigned int i) throw() {
    chipData.resize(i);
}
}
