#ifndef SCTDATA_IO_TRIMRANGETESTRESULTSTREAMER_V1_H
#define SCTDATA_IO_TRIMRANGETESTRESULTSTREAMER_V1_H

#include "Sct/Streamer.h"
#include "../TrimRangeTestResult.h"

using namespace SctData;

namespace SctData {
namespace IO {


/**
 * This class allows publishing and refreshing of TrimRangeTestResult objects to and from IS.
 * The published and refreshed elements are:
 * 
 */
class TrimRangeTestResultStreamer_v1 : public Streamer {
public:
    //Streamer overrides
    virtual void write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(LogicError, IoError);
    virtual shared_ptr<Streamable> read(IStream& in, const IOManager& manager) const throw(LogicError, IoError);
    virtual void read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError);
    virtual unsigned getVersion() const throw() {return s_version;}
 
private:
    void writeData(OStream& out, const TrimRangeTestResult::ChipTrimData& ob, const IOManager& manager) const throw(Sct::LogicError, Sct::IoError);
    void readData(IStream& in, TrimRangeTestResult& mytest, TrimRangeTestResult::ChipTrimData& ob, const IOManager& manager) const throw(Sct::LogicError, Sct::IoError);

    void writeTrim(OStream& out, const TrimRangeTestResult::ChipTrim& ob, const IOManager& manager) const throw(Sct::LogicError, Sct::IoError);
    void readTrim(IStream& in, TrimRangeTestResult& mytest, TrimRangeTestResult::ChipTrim& ob, const IOManager& manager) const throw(Sct::LogicError, Sct::IoError);

    TrimRangeTestResultStreamer_v1() throw();	///< Constructor is private
  static unsigned s_version;
  static bool inMap;				///< The static dummy variable for the IOManager map
};
}
}
#endif // #ifndef SCTDATA_IO_TRIMRANGETESTRESULTSTREAMER_V1_H
