#include "../SingleVariableTestResult.h"
#include "SingleVariableTestResultStreamer_v1.h"
#include <vector>

using namespace Sct;

namespace SctData {
namespace IO {

/* READ NOTES ON STREAMERS AND VERSIONS BEFORE EDITING THIS FILE! */
unsigned SingleVariableTestResultStreamer_v1::s_version=1;
	
SingleVariableTestResultStreamer_v1::SingleVariableTestResultStreamer_v1() throw() {
}

bool SingleVariableTestResultStreamer_v1::inMap = IOManager::addToMap("SctData::SingleVariableTestResult",  auto_ptr<Streamer>(new SingleVariableTestResultStreamer_v1()));

shared_ptr<Streamable> SingleVariableTestResultStreamer_v1::read(IStream& in, const IOManager& manager) const throw(LogicError, IoError) {
   throw Sct::IllegalStateError("Request to make a SingleVariableTestResult, which is an abstract class", __FILE__, __LINE__);
}

void SingleVariableTestResultStreamer_v1::write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    //Let superclass do its work
    manager.writeImpl(out, ob, "SctData::TestResult");

    const SingleVariableTestResult& mytest = dynamic_cast<const SingleVariableTestResult&>(ob);

    out << (double) 0.;

    unsigned int nopt=mytest.getNOptima();
    out << nopt;
    for (unsigned int i=0; i<nopt; ++i) {
        out << mytest.getOptimum(i);
    }
}

void SingleVariableTestResultStreamer_v1::read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    manager.readImpl(in, ob, "SctData::TestResult");

    SingleVariableTestResult& mytest = dynamic_cast<SingleVariableTestResult&>(ob);
    double fraction;
    in >> fraction;
    unsigned int nopt;
    in >> nopt;
    mytest.setNOptima(nopt);
    for (unsigned int ichip=0; ichip<nopt; ++ichip) {
        double opt;
        in >> opt ;
        mytest.setOptimum(ichip, opt);
    }
}

}
}
