#include "ScanPointsStreamer_v1.h"
#include "../ScanPoints.h"

#include "Sct/Streamable.h"
#include "Sct/IOManager.h"

using namespace SctData;

namespace SctData {
namespace IO {

/* READ NOTES ON STREAMERS AND VERSIONS BEFORE EDITING THIS FILE! */
unsigned ScanPointsStreamer_v1::s_version=1;

ScanPointsStreamer_v1::ScanPointsStreamer_v1() throw() {}

bool ScanPointsStreamer_v1::inMap = IOManager::addToMap("SctData::ScanPoints",  std::auto_ptr<Streamer>(new ScanPointsStreamer_v1()));


shared_ptr<Streamable> ScanPointsStreamer_v1::read(IStream& in, const IOManager& manager) const throw(Sct::LogicError, Sct::IoError) {
    std::auto_ptr<Streamable> m (new ScanPoints());
    read(in, *m, manager);
    return shared_ptr<Streamable>(m);
}

void ScanPointsStreamer_v1::write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(Sct::LogicError, Sct::IoError) {
    //Downcast should always work!
    const ScanPoints& points = dynamic_cast<const ScanPoints&>(ob);

    unsigned short npoints = points.getNPoints();

    //Copy into array
    float pts[npoints];
    unsigned int nEvents[npoints];
    unsigned int nErrorEvents[npoints];
    for (int i=0; i<npoints; ++i) {
        pts[i] = (float)points[i];
        nEvents[i] = points.getNEvents(i);
        nErrorEvents[i] = points.getNErrorEvents(i);
    }

    out << npoints;
    out.put(pts, npoints);
    out.put(nEvents, npoints);
    out.put(nErrorEvents, npoints);
}

void ScanPointsStreamer_v1::read(IStream& in, Streamable& ob, const IOManager& manager) const throw(Sct::LogicError, Sct::IoError) {
    //Downcast should always work!
    ScanPoints& points = dynamic_cast<ScanPoints&>(ob);

    unsigned short npoints;
    unsigned int size;
    float* pts;
    unsigned int* nEvents;
    unsigned int* nErrorEvents;

    in >> npoints;
    in.get(&pts, size);
    if (size != npoints) {	///@todo Exception here
        return;
    }
    in.get(&nEvents, size);
    if (size != npoints) {	///@todo Exception here
        return;
    }
    in.get(&nErrorEvents, size);
    if (size != npoints) {	///@todo Exception here
        return;
    }

    //Put it all into the ScanPoints class
    for (unsigned int i=0; i<npoints; ++i) {
        points.addPoint(pts[i], nEvents[i], nErrorEvents[i]);
    }
}
}
}
