#include "FitObjectStreamer_v1.h"
#include "../FitObject.h"
#include "../AllFitObject.h"
#include <is/isinfo.h>

using namespace Sct;
using namespace boost;

namespace SctData {
namespace IO {

unsigned FitObjectStreamer_v1::s_version=1;
unsigned ErfFitObjectStreamer_v1::s_version=1;
unsigned ErfcFitObjectStreamer_v1::s_version=1;
unsigned GausFitObjectStreamer_v1::s_version=1;
unsigned TopHatFitObjectStreamer_v1::s_version=1;


/* READ NOTES ON STREAMERS AND VERSIONS BEFORE EDITING THIS FILE! */

bool FitObjectStreamer_v1::inMap = IOManager::addToMap("SctData::FitObject",  std::auto_ptr<Streamer>(new FitObjectStreamer_v1()));

shared_ptr<Streamable> FitObjectStreamer_v1::read(IStream&, IOManager const&) const throw(LogicError, IoError) {
  throw LogicError("Cannot make a FitObject - abstract class",__FILE__,__LINE__);
}

void FitObjectStreamer_v1::write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    //Dynamic cast should always be safe
    const FitObject& fo = dynamic_cast<const FitObject&>(ob);

//   Version 1:
    out << fo.getChiSquared() << fo.getNDF();
    for (int i=0; i<fo.getNPar(); ++i) {
        out << fo.getParameter(i) << fo.getParError(i) << fo.isFixed(i);
    }

    for (int i=0; i<fo.getNDim(); ++i) {
    	out << fo.getVarMin(i) << fo.getVarMax(i);
    }
    /* Version 2:
    //We do our own buffering here:
    unsigned int doubleSize = fo.getNPar() * 2 + fo.getNDim() * 2 + 1;
    unsigned int dimStart = fo.getNPar() * 2 + 1;
    double doubleArray[doubleSize];
    unsigned int boolSize = fo.getNPar();
    bool boolArray[boolSize];
    
    doubleArray[0] = fo.getChiSquared();
    for (int i=0; i<fo.getNPar(); ++i) {
	doubleArray[2*i+1] = fo.getParameter(i);
	doubleArray[2*i+2] = fo.getParError(i);
	boolArray[i] = fo.isFixed(i);
    }
    for (int i=0; i<fo.getNDim(); ++i) {
	doubleArray[dimStart + i*2] = fo.getVarMin(i);
	doubleArray[dimStart + i*2 + 1] = fo.getVarMax(i);
    }
    
    out.put(doubleArray, doubleSize);
    out.put(boolArray, boolSize);*/
}

void FitObjectStreamer_v1::read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    //Dynamic cast should always be safe
    //cout << "Dynamic_cast read called" << endl;
    FitObject& fo = dynamic_cast<FitObject&>(ob);
    read(in, fo, manager);
}

void FitObjectStreamer_v1::read(IStream& in, FitObject& fo, const IOManager& manager) const throw(LogicError, IoError) {    
//Version 1
    int ndf;
    double chi2;
    bool fixed;
    int ndim = fo.getNDim();
    int npar = fo.getNPar();
    in >> chi2 >> ndf;
    fo.setChiSquared(chi2);
    fo.setNDF(ndf);

    for (int i=0; i<npar; i++) {
        double param, paramError;
        in >> param >> paramError >> fixed;
        fo.setParameter(i, param);
        fo.setParError(i, paramError);
	fo.fixParameter(i, fixed);
    }

    
    for (int i=0; i<ndim; i++) {
        double varMin, varMax;
        in >> varMin >> varMax;
        fo.setVarMin(i, varMin);
        fo.setVarMax(i, varMax);
    }
/* Version 2    
    unsigned int doubleSize = fo.getNPar() * 2 + fo.getNDim() * 2 + 1;
    unsigned int dimStart = fo.getNPar() * 2 + 1;
    double doubleArray[doubleSize];
    unsigned int boolSize = fo.getNPar();
    bool boolArray[boolSize];    
    
    in.get(doubleArray, doubleSize);
    in.get(boolArray, boolSize);
    
    fo.setChiSquared(doubleArray[0]);
    for (int i=0; i<fo.getNPar(); ++i) {
	fo.setParameter(i, doubleArray[2*i+1]);
	fo.setParError(i, doubleArray[2*i+2]);
	fo.fixParameter(i, boolArray[i]);
    }
    for (int i=0; i<fo.getNDim(); ++i) {
	fo.setVarMin(i, doubleArray[dimStart + i*2]);
	fo.setVarMax(i, doubleArray[dimStart + i*2 + 1]);
    }
    */
}

bool ErfcFitObjectStreamer_v1::inMap = IOManager::addToMap("SctData::ErfcFitObject",  auto_ptr<Streamer>(new ErfcFitObjectStreamer_v1()));

shared_ptr<Streamable> ErfcFitObjectStreamer_v1::read(IStream& in, const IOManager& manager) const throw(LogicError, IoError) {
    shared_ptr<ErfcFitObject> f = ErfcFitObject::create();
    FitObjectStreamer_v1::read(in, *f, manager);
    return f;
}

void ErfcFitObjectStreamer_v1::read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    FitObjectStreamer_v1::read(in, ob, manager);
}


bool ErfFitObjectStreamer_v1::inMap = IOManager::addToMap("SctData::ErfFitObject",  auto_ptr<Streamer>(new ErfFitObjectStreamer_v1()));

shared_ptr<Streamable> ErfFitObjectStreamer_v1::read(IStream& in, const IOManager& manager) const throw(LogicError, IoError) {
    shared_ptr<Streamable> f (new ErfFitObject());
    FitObjectStreamer_v1::read(in, *f, manager);
    return f;
}

void ErfFitObjectStreamer_v1::read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    FitObjectStreamer_v1::read(in, ob, manager);
}



bool GausFitObjectStreamer_v1::inMap = IOManager::addToMap("SctData::GausFitObject",  auto_ptr<Streamer>(new GausFitObjectStreamer_v1()));

shared_ptr<Streamable> GausFitObjectStreamer_v1::read(IStream& in, const IOManager& manager) const throw(LogicError, IoError) {
    shared_ptr<Streamable> f (new GausFitObject());
    FitObjectStreamer_v1::read(in, *f, manager);
    return f;
}

void GausFitObjectStreamer_v1::read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    FitObjectStreamer_v1::read(in, ob, manager);
}



bool TopHatFitObjectStreamer_v1::inMap = IOManager::addToMap("SctData::TopHatFitObject",  auto_ptr<Streamer>(new TopHatFitObjectStreamer_v1()));

shared_ptr<Streamable> TopHatFitObjectStreamer_v1::read(IStream& in, const IOManager& manager) const throw(LogicError, IoError) {
    shared_ptr<Streamable> f (new TopHatFitObject());
    FitObjectStreamer_v1::read(in, *f, manager);
    return f;
}

void TopHatFitObjectStreamer_v1::read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    FitObjectStreamer_v1::read(in, ob, manager);
}

}
}
