#include "DefectListStreamer_v1.h"
#include "../DefectList.h"
#include "Sct/LogicErrors.h"
#include "Sct/IoExceptions.h"

using namespace Sct;

namespace SctData {
namespace IO {

unsigned DefectListStreamer_v1::s_version=1;
/* READ NOTES ON STREAMERS AND VERSIONS BEFORE EDITING THIS FILE! */
	
DefectListStreamer_v1::DefectListStreamer_v1() throw() {}

bool DefectListStreamer_v1::inMap = IOManager::addToMap("SctData::DefectList",  auto_ptr<Streamer>(new DefectListStreamer_v1()));

void DefectListStreamer_v1::write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    //cast should always be safe
    const DefectList& m = dynamic_cast<const DefectList&>(ob);

    const std::list<Defect>& mylist = m.getAllDefects();
    out << mylist.size();
    for (std::list<Defect>::const_iterator i = mylist.begin(); 
	 i != mylist.end() ; ++i) {
        ModuleElement el=(*i).getModuleElement();
        out << helper.getRepresentation((*i).getPrototype()) << el.getFirst() << el.getNChannels();
    }
}

shared_ptr<Streamable> DefectListStreamer_v1::read(IStream& in, const IOManager& manager) const throw(LogicError, IoError) {
    shared_ptr<Streamable> m (new DefectList());
    read(in, *m, manager);
    return m;
}

void DefectListStreamer_v1::read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    DefectList& m = dynamic_cast<DefectList&>(ob);

    int nDefects = -1;
    int rep = 1;
    unsigned int startChannel = 0;
    unsigned int nChannels = 0;

    in >> nDefects;
    for (int i=0; i<nDefects; ++i) {
        in >> rep >> startChannel >> nChannels;
        m.addDefect(Defect(helper.getFromRep(rep), ModuleElement(startChannel, startChannel+nChannels-1)));
    }
}
}
}
