#ifndef SCTDATA_IO_ChipConfigurationStreamer_v1_H
#define SCTDATA_IO_ChipConfigurationStreamer_v1_H

#include <CommonWithDsp/sctStructure.h>
#include "Sct/Streamable.h"
#include "Sct/Streamer.h"
#include "Sct/Exception.h"
#include "Sct/LogicErrors.h"
#include "Sct/IoExceptions.h"

using namespace Sct;

namespace SctData {
namespace IO {

/**
This class is an Streamer for reading/writing ChipConfigurations to/from IS.
*/
class ChipConfigurationStreamer_v1 : public virtual Streamer {
public:
    //Streamer_v1 overrides
    virtual void write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(LogicError, IoError);
    virtual shared_ptr<Streamable> read(IStream& in, const IOManager& manager) const throw(LogicError, IoError);
    virtual void read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError);
    virtual unsigned getVersion() const throw() {return s_version;}
    
private:
    ChipConfigurationStreamer_v1() throw();		///< The private constructor
    static unsigned s_version;
    static bool inMap;				///< The static dummy variable for the IOManager map
};
}
}
#endif //#ifndef SCTDATA_IO_ChipConfigurationStreamer_v1_H
