#ifndef FULLBYPASSTESTRESULT_H
#define FULLBYPASSTESTRESULT_H

#include "TestResult.h"
#include "Sct/RangedVector.h"

namespace SctData{
class ThresholdVariable;
    /**
       The class represents the result of a pipeline test.	
       As far as I can see, this involves a defect list only, which is in TestResult.
       @author Alan Barr
    */
    class FullBypassTestResult : public TestResult {
    public:
	FullBypassTestResult() throw();
	
	/**
	   Constructor.
	*/
	FullBypassTestResult(unsigned int runNumber, const string& moduleName) throw();
	
	/**
	   Destructor
	*/
	virtual ~FullBypassTestResult() throw();
	
	//Override
	virtual string getClassName() const throw();

	class ChipFBResult{
	public:
	    ChipFBResult() : status_direct(-2) , vdd_direct(10.),
		status_bypass(-2), vdd_bypass(10.) {}
	    /** 
		-3 token/data does not work at any voltage
		-2 token/data not tested
		-1 value gives minimal accessible vdd
		0 value gives minimal functional vdd
		1 token/data works for all tested vdd
	    */
	    short status_direct;  
	    float vdd_direct;
	    short status_bypass;
	    float vdd_bypass;
	};
	
	/**
	   get ChipResult @param index chip in range 0->11 
	*/
	ChipFBResult& getChipResult(const unsigned index);
	/**
	   const get ChipResult @index chip in range 0->11 
	*/
	const ChipFBResult& getChipResult(const unsigned index) const;
	
	void setNConfig(const unsigned n){m_nconf=n;}
	unsigned getNConfig() const {return m_nconf;} 
	
/**
   Nominal value of the digital voltage is set by AnalysisService::FullBypassAlgorithm .
 */
	void setVddNom(float f) {m_vdd_nom=f;}
	float getVddNom() const {return m_vdd_nom;}
	    
    private:
	RangedVector<ChipFBResult> chipResults;
	float m_vdd_nom;
	unsigned m_nconf;
    };
}// end of namespace SctData
#endif //#ifndef FULLBYPASSTESTRESULT_H
