#ifndef ERFFITOBJECT_H
#define ERFFITOBJECT_H

#include "FitObject.h"

namespace SctData{

/** 
 * <p>
 * @author Alan Barr
 * @date 9 December 2002
 * </p><p>
 * A derived class of the FitObject class for an error function
 * </P><P>Parameters: Prefactor, Mean, Sigma</p><p>
 * The evaluation of the function is done here through the root TMath
 * class function Erf(x) = (2/sqrt(pi)) Integral(exp(-t^2))dt between 0 and x
 */

class ErfFitObject : public FitObject {
public:
    /// Default Constructor
    ErfFitObject() ;
    
    /// Constructor from ROOT TF1
    ErfFitObject(const TF1& rootfunc);
	
    virtual shared_ptr<FitObject> clone() const throw();


    virtual string getClassName() const throw() {return "SctData::ErfFitObject";}
    	
    /// Destructor does nothing	
    virtual ~ErfFitObject() throw() {;}

    ///Equality with a ROOT TF1
    ErfFitObject& operator=(const TF1& rootfunc) throw(LogicError) ;
protected:
    /**
     * call the correct constructor for making a ROOT TF1
     */
    virtual auto_ptr<TF1> makeBasicRootTF1() const throw(LogicError) ;
    
private:
    static vector<string> createParNames();
    static vector<string> parNames;
}; // end of definition of class ErfFitObject

} // end of namespace SctData

#endif // #ifndef ERFFITOBJECT_H

