#include "CachedFunction1D.h"

namespace SctData{
    
    CachedFunction1D::CachedFunction1D(double min, double max, double delta, double (*function) (double) ) throw() :
	min(min), max(max), delta(delta), function(function) {
	
	//Make sure min and max are definately included in range
	nvalue= (int)(ceil(max/delta) - floor(min/delta));
	
	values=new double[nvalue];
	makeTable();
	invdelta= 1./ delta;
    }
    
    CachedFunction1D::~CachedFunction1D() throw() {
	delete [] values;
    }
    
    void CachedFunction1D::makeTable() throw() {
	for ( int i=0; i<nvalue; ++i){ 
	    double xx = min + delta*i;
	    values[i] = (*function)(xx) ;
	};
    }

}
