#include "SliceDataWriter.h"
#include "scan.h"
#include "ScanWriterFactory.h"
#include "ScanResultWriter.h"
#include "dataTypes.h"
#include "Sct/UnsupportedOperationError.h"

namespace SctData {

//Make sure we are in the map
bool SliceDataWriter::inMap = ScanWriterFactory::getFactory().addWriterToMap(SR_DT_SLICE, ScanResultWriter::getRawWriter(), *(new SliceDataWriter()));

//Do the publishing!
void SliceDataWriter::writeData(scan_result_ptrs& scanResult, OStream& out) {
    ScanResultWriter::writeClass("SliceRawData", out);
    //cout << "Publishing slice data" << endl;
    //data
    switch (scanResult.header.width) {
    case SR_WD_32: {
            out << scanResult.header.size/2 << scanResult.header.dataType << scanResult.header.width;

            UINT32* data = reinterpret_cast<UINT32*>(scanResult.data);
            out.put(data, scanResult.header.size/2);
        }
        break;

    case SR_WD_16: {
            //data header - no need to output width
            out << scanResult.header.size << scanResult.header.dataType << scanResult.header.width;

            UINT16* data = reinterpret_cast<UINT16*>(scanResult.data);
            out.put(data, scanResult.header.size);
        }
        break;

    default:
	ostringstream oss;
	oss << "SliceDataWriter only supports 16 and 32 bit widths, was given: " << scanResult.header.width;
        throw UnsupportedOperationError(oss.str(), __FILE__, __LINE__);
        break;
    }
}

}
