#include "ScanWriterFactory.h"
#include "ScanResultWriter.h"
#include "ScanDataWriter.h"
#include "Sct/IoExceptions.h"
#include <sstream>

namespace SctData {

ScanWriterFactory::ScanWriterFactory() {}

	
ScanWriterFactory& ScanWriterFactory::getFactory() {
	static ScanWriterFactory* bertha = new ScanWriterFactory();
	return *bertha;
}

bool ScanWriterFactory::addWriterToMap(UINT16 dataType, ScanResultWriter& resultWriter, ScanDataWriter& dataWriter) {
	if (writerMap.find(dataType) != writerMap.end()) return false;
	writerMap[dataType] = pair<ScanResultWriter*, ScanDataWriter*>(&resultWriter, &dataWriter);
	return true;
}

ScanDataWriter& ScanWriterFactory::getDataWriter(UINT16 dataType) {
    if (getFactory().writerMap.find(dataType) == getFactory().writerMap.end()) {
	std::ostringstream oss;
	oss << "No ScanDataWriter for dataType: " << dataType;
	throw Sct::NoSuchStreamerException("ScanHeader.dataType", oss.str(), __FILE__, __LINE__);
    }
    return *(getFactory().writerMap[dataType].second);
}

ScanResultWriter& ScanWriterFactory::getResultWriter(UINT16 dataType) {
    if (getFactory().writerMap.find(dataType) == getFactory().writerMap.end()) {
    	std::ostringstream oss;
	oss << "No ScanResultWriter for dataType: " << dataType;
	throw Sct::NoSuchStreamerException("ScanHeader.dataType", oss.str(), __FILE__, __LINE__);
    }
    return *(getFactory().writerMap[dataType].first);	
}


}
