#include "Sct/ISProxy/ISProxy.h"
#include "Sct/SctNames.h"
#include "Sct/File/IONameFile.h"
#include "Sct/ISProxy/IOManagerISProxy.h"
#include <iostream>
#include <string>

/**
This program puts an ISProxy object into a given IS server
This is handy if you want to put back a reference to one of 
the data files.

@author Matthew Palmer
*/

using namespace Sct;
using namespace Sct::IS;
using namespace Sct::File;
using namespace Sct::ISProxy;
using namespace std;

int printHelp() {
        cout << "Usage: ProxyPublish <IS server> <class name> <uniqueID>" << endl;
	cout << "   or: ProxyPublish -f <filelist>" << endl;
        cout << "ProxyPublish puts an ISProxy into IS given appropriate information" << endl;
        cout << "This is useful if you still have the data transfer files, but the IS server has been restarted" << endl;
        cout << "The arguments should be obvious from the usage" << endl;
        return 0;
}

void publishProxy(string isServer, string className, string uniqueID) {
        IOParamsIS params(isServer);
        Sct::ISProxy::ISProxy proxy(uniqueID, className);
        IOManagerISProxy::instance().write(proxy, &params);
}

void publishFile(string fileName) {
    IONameFile file(fileName);
    //Try and guess ISServer name    
    string isServer = SctNames::getEventDataName();
    if (file.getClassName() == "SctData::RawScanResult") isServer = SctNames::getEventDataName();
    else if (file.getClassName() == "SctData::FitScanResult") isServer = SctNames::getFittedDataName();
    else if (file.getClassName().find("TestResult") != file.getClassName().npos) isServer = SctNames::getTestDataName();
    publishProxy(isServer, file.getClassName(), file.getUniqueID());
}

int main(int argc, char** argv) {
        if (argc < 2) return printHelp();
	try {
	    if (argv[1] == string("-f")) {
		for (int i=2; i<argc; ++i) {
		    publishFile(argv[i]);
		}
	    } else {
		if (argc != 4) return printHelp();
		publishProxy(argv[1], argv[2], argv[3]);
	    }
        } catch (Throwable& t) {
                cout << t.what() << endl;
                return 1;
        }
        return 0;
}
