#ifndef SERIALIZABLE_H
#define SERIALIZABLE_H

#include <string>
#include "Streamable.h"

using std::string;

namespace Sct {

/**
Classes should implement this interface if they want to be serialized by the IO system.
@author Matthew Palmer	
*/
class Serializable : public virtual Streamable {
public:

    /**
    For objects to be stored, there must be some way of identifying them.
    This function must be implemented to return some unique identifier for objects of this precise className
    @return a unique string for this class
    @throw LogicError if the class is unable to generate a uniqueID for some reason
    */
    virtual string getUniqueID() const = 0;
}
;

}

#endif //#ifndef SERIALIZABLE_H
