#include "LogicErrors.h"

namespace Sct {
    
LogicError::LogicError(const string& msg, const string& file, int line) throw() {
    initialize("LOGIC_ERROR", "Sct::LogicError", msg, 0, file, line);
}
    
LogicError::LogicError(Throwable& cause, const string& file, int line) throw() {
    initialize("LOGIC_ERROR", "Sct::LogicError", "", &cause, file, line);
}
    
LogicError::LogicError(const string& msg, Throwable& cause, const string& file, int line) throw() {
    initialize("LOGIC_ERROR", "Sct::LogicError", msg, &cause, file, line);
}


  
InvalidArgumentError::InvalidArgumentError(const string& msg, const string& file, int line) throw() {
    initialize("BAD_ARG", "Sct::InvalidArgumentError", msg, 0, file, line);
}
    
InvalidArgumentError::InvalidArgumentError(Throwable& cause, const string& file, int line) throw() {
    initialize("BAD_ARG", "Sct::InvalidArgumentError", "", &cause, file, line);
}
    
InvalidArgumentError::InvalidArgumentError(const string& msg, Throwable& cause, const string& file, int line) throw() {
    initialize("BAD_ARG", "Sct::InvalidArgumentError", msg, &cause, file, line);
}
   



InvariantViolatedError::InvariantViolatedError(const string& msg, const string& file, int line) throw() {
    initialize("BAD_INVARIANT", "Sct::InvariantViolatedError", msg, 0, file, line);
}
    
InvariantViolatedError::InvariantViolatedError(Throwable& cause, const string& file, int line) throw() {
    initialize("BAD_INVARIANT", "Sct::InvariantViolatedError", "", &cause, file, line);
}
    
InvariantViolatedError::InvariantViolatedError(const string& msg, Throwable& cause, const string& file, int line) throw() {
    initialize("BAD_INVARIANT", "Sct::InvariantViolatedError", msg, &cause, file, line);
}




IllegalStateError::IllegalStateError(const string& msg, const string& file, int line) throw() {
    initialize("BAD_STATE", "Sct::IllegalStateError", msg, 0, file, line);
}
    
IllegalStateError::IllegalStateError(Throwable& cause, const string& file, int line) throw() {
    initialize("BAD_STATE", "Sct::IllegalStateError", "", &cause, file, line);
}
    
IllegalStateError::IllegalStateError(const string& msg, Throwable& cause, const string& file, int line) throw() {
    initialize("BAD_STATE", "Sct::IllegalStateError", msg, &cause, file, line);
}

    
}
