#include "IpcException.h"

namespace Sct {

//IpcException methods
IpcException::IpcException(const ilu_Exception& error, const string& msg, const string& file, int line) throw() : iluMsg(error) {
    initialize("IPC_EXCEPTION", "Sct::IpcException", msg, 0, file, line);
}

IpcException::IpcException(const ilu_Exception& error, Throwable& cause, const string& file, int line) throw() : iluMsg(error) {
    initialize("IPC_EXCEPTION", "Sct::IpcException", "", &cause, file, line);
}

IpcException::IpcException(const ilu_Exception& error, const string& msg, Throwable& cause, const string& file, int line) throw() : iluMsg(error) {
    initialize("IPC_EXCEPTION", "Sct::IpcException", msg, &cause, file, line);
}

   
const ilu_Exception& IpcException::getIluException() const throw() {
    return iluMsg;
}

shared_ptr<Throwable> IpcException::clone() const throw() {
    return shared_ptr<Throwable>(new IpcException(*this));
}

string IpcException::getMessage() const throw() {
    std::ostringstream output;
    output << msg << " [Return code = " << iluMsg << "]";
    return output.str();
}


}
